/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.meshkeeper.distribution.registry.zk;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.fusesource.meshkeeper.RegistryWatcher;
import org.fusesource.meshkeeper.distribution.registry.AbstractRegistryClient;
import org.fusesource.meshkeeper.distribution.registry.zk.ZooKeeperChildWatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZooKeeperRegistry
extends AbstractRegistryClient {
    Log LOG = LogFactory.getLog(((Object)((Object)this)).getClass());
    HashMap<String, ZooKeeperChildWatcher> watcherMap = new HashMap();
    private CountDownLatch connected = new CountDownLatch(1);
    private String connectUrl = "localhost:2181";
    private String userid = "guest";
    private String password = "";
    private long connectTimeout = 30000L;
    private int sessionTimeout = 30000;
    private ZooKeeper zk;

    public ZooKeeper getZooKeeper() {
        return this.zk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        ZooKeeperRegistry zooKeeperRegistry = this;
        synchronized (zooKeeperRegistry) {
            if (this.zk == null) {
                URI uri = new URI(this.connectUrl);
                this.zk = new ZooKeeper(uri.getAuthority() + ":" + uri.getPort(), this.sessionTimeout, new Watcher(){

                    public void process(WatchedEvent event) {
                        switch (event.getState()) {
                            case SyncConnected: {
                                ZooKeeperRegistry.this.connected.countDown();
                            }
                        }
                    }
                });
                this.zk.addAuthInfo("digest", (this.userid + ":" + this.password).getBytes());
            }
        }
        if (this.connectTimeout > 0L) {
            if (!this.connected.await(this.connectTimeout, TimeUnit.MILLISECONDS)) {
                throw new IOException("Failed to connect to ZooKeeper at " + this.connectUrl + " within " + this.connectTimeout + " milliseconds.");
            }
        } else {
            this.connected.await();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws Exception {
        ZooKeeperRegistry zooKeeperRegistry = this;
        synchronized (zooKeeperRegistry) {
            if (this.zk != null) {
                this.zk.close();
            }
            this.connected.countDown();
            this.connected = new CountDownLatch(1);
            this.zk = null;
        }
    }

    public String addRegistryObject(String path, boolean sequential, Serializable o) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream os = new ObjectOutputStream(baos);
        os.writeObject(o);
        os.close();
        return this.addRegistryData(path, sequential, baos.toByteArray());
    }

    public <T> T getRegistryObject(String path) throws Exception {
        byte[] data = this.getRegistryData(path);
        if (data == null) {
            return null;
        }
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(data));
        return (T)in.readObject();
    }

    public byte[] getRegistryData(String path) throws Exception {
        this.checkConnected();
        Stat stat = new Stat();
        try {
            return this.zk.getData(path, false, stat);
        }
        catch (KeeperException.NoNodeException nne) {
            return null;
        }
    }

    public String addRegistryData(String path, boolean sequential, byte[] data) throws Exception {
        this.checkConnected();
        if (this.LOG.isWarnEnabled() && data != null && data.length > 20000) {
            this.LOG.warn((Object)("Warning -- long data length for " + path + ": " + data.length));
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("Registering " + path + " length=" + (data != null ? data.length : 0)));
        }
        try {
            if (sequential) {
                return this.zk.create(path, data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
            }
            return this.zk.create(path, data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        }
        catch (KeeperException.NoNodeException nne) {
            this.createParentPath(path);
            return this.addRegistryData(path, sequential, data);
        }
    }

    public void removeRegistryData(String path, boolean recursive) throws Exception {
        block8: {
            this.checkConnected();
            try {
                if (this.LOG.isDebugEnabled()) {
                    this.LOG.debug((Object)("Removing: " + path));
                }
                if (path.equals("/")) {
                    for (String child : this.zk.getChildren(path, false)) {
                        if (child.equals("zookeeper")) continue;
                        this.removeRegistryData("/" + child, true);
                    }
                    return;
                }
                this.zk.delete(path, -1);
                if (this.LOG.isDebugEnabled()) {
                    this.LOG.debug((Object)("Removed: " + path));
                }
                this.deleteEmptyAncestors(path);
            }
            catch (KeeperException.NoNodeException nne) {
            }
            catch (KeeperException.NotEmptyException nee) {
                this.zk.setData(path, null, -1);
                if (!recursive) break block8;
                for (String child : this.zk.getChildren(path, false)) {
                    this.removeRegistryData(path + "/" + child, true);
                }
            }
        }
    }

    public Collection<String> list(String path, boolean recursive, String ... filters) throws Exception {
        if (filters != null) {
            HashSet<String> filterSet = new HashSet<String>();
            filterSet.addAll(Arrays.asList(filters));
            return this.list(path, recursive, new LinkedList<String>(), filterSet);
        }
        return this.list(path, recursive, new LinkedList<String>(), Collections.EMPTY_LIST);
    }

    private Collection<String> list(String path, boolean recursive, Collection<String> results, Collection<String> filters) throws Exception {
        try {
            List children = null;
            byte[] data = this.zk.getData(path, false, null);
            if (data != null && data.length > 0) {
                results.add(path + " [" + data.length + "]");
            } else {
                children = this.zk.getChildren(path, recursive);
                if (children.size() == 0) {
                    results.add(path + " [" + (data == null ? "-" : Integer.valueOf(data.length)) + "]");
                    if (recursive) {
                        return results;
                    }
                }
            }
            if (recursive) {
                children = this.zk.getChildren(path, recursive);
                if (path.endsWith("/")) {
                    path = path.substring(0, path.length() - 1);
                }
                for (String child : children) {
                    String childPath = path + "/" + child;
                    if (filters.remove(childPath)) continue;
                    this.list(childPath, recursive, results, filters);
                }
            }
        }
        catch (KeeperException.NoNodeException nne) {
            return results;
        }
        return results;
    }

    public synchronized void addRegistryWatcher(String path, RegistryWatcher watcher) throws Exception {
        this.checkConnected();
        if (path.endsWith("/")) {
            path.substring(0, path.length() - 1);
        }
        this.createParentPath(path + "/");
        ZooKeeperChildWatcher w = this.watcherMap.get(path);
        if (w == null) {
            w = new ZooKeeperChildWatcher(this.zk, path);
            this.watcherMap.put(path, w);
        }
        w.addWatcher(watcher);
    }

    public synchronized void removeRegistryWatcher(String path, RegistryWatcher watcher) {
        ZooKeeperChildWatcher w = this.watcherMap.get(path);
        if (w == null) {
            return;
        }
        if (w.removeWatcher(watcher)) {
            this.watcherMap.remove(path);
        }
    }

    private void deleteEmptyAncestors(String path) throws KeeperException, InterruptedException {
        int ls = path.lastIndexOf("/");
        if (ls > 1) {
            String parent = path.substring(0, ls);
            byte[] data = this.zk.getData(parent, false, null);
            if (data != null && data.length > 0) {
                return;
            }
            try {
                this.zk.delete(parent, -1);
                if (this.LOG.isDebugEnabled()) {
                    this.LOG.debug((Object)("Removed: " + parent));
                }
            }
            catch (KeeperException.NotEmptyException nee) {
                return;
            }
            catch (KeeperException.NoNodeException nn) {
                return;
            }
            this.deleteEmptyAncestors(parent);
        }
    }

    private void createParentPath(String path) throws KeeperException, InterruptedException {
        int ls = path.lastIndexOf("/");
        if (ls > 1) {
            String parent = path.substring(0, ls);
            try {
                this.zk.create(parent, null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
            catch (KeeperException.NodeExistsException e) {
                return;
            }
            catch (KeeperException.NoNodeException nne) {
                this.createParentPath(parent);
                this.zk.create(parent, null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug((Object)("Created: " + parent));
            }
        }
    }

    private void checkConnected() throws Exception {
        if (this.connected.getCount() > 0L) {
            throw new Exception("Not Connected");
        }
    }

    public String getConnectUrl() {
        return this.connectUrl;
    }

    public void setConnectUrl(String connectUrl) {
        this.connectUrl = connectUrl;
    }

    public String getUserid() {
        return this.userid;
    }

    public void setUserid(String userid) {
        this.userid = userid;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setSessionTimeout(int sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    public String toString() {
        return "ZooKeeperRegistry@" + this.connectUrl;
    }
}

