/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.meshkeeper.distribution.registry.zk;

import java.io.File;
import java.net.InetAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.zookeeper.server.NIOServerCnxn;
import org.apache.zookeeper.server.persistence.FileTxnLog;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.fusesource.meshkeeper.control.ControlService;
import org.fusesource.meshkeeper.distribution.registry.RegistryClient;
import org.fusesource.meshkeeper.distribution.registry.zk.ZooKeeperFactory;

public class ZooKeeperServer
implements ControlService {
    Log log = LogFactory.getLog(this.getClass());
    private int port = 2181;
    private String userid = "guest";
    private String password = "";
    private String directory = "zookeeper-server-data";
    private boolean purge;
    private String serviceUri;
    int tick = 10000;
    private NIOServerCnxn.Factory serverFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        File file = new File(this.directory);
        boolean doPurge = this.purge;
        int preallocateSize = 1024;
        System.setProperty("zookeeper.preAllocSize", "" + preallocateSize);
        FileTxnLog.setPreallocSize((long)preallocateSize);
        this.log.debug((Object)("Preallocate Size: " + preallocateSize));
        org.apache.zookeeper.server.ZooKeeperServer zkServer = new org.apache.zookeeper.server.ZooKeeperServer();
        FileTxnSnapLog ftxn = new FileTxnSnapLog(file, file);
        zkServer.setTxnLogFactory(ftxn);
        zkServer.setTickTime(this.tick);
        this.serverFactory = new NIOServerCnxn.Factory(this.port);
        this.serverFactory.startup(zkServer);
        String actualHost = InetAddress.getLocalHost().getCanonicalHostName();
        this.serviceUri = "zk:tcp://" + actualHost + ":" + zkServer.getClientPort();
        if (doPurge) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Purging registry");
            }
            RegistryClient zk = null;
            try {
                zk = new ZooKeeperFactory().createPlugin(this.getServiceUri());
                zk.removeRegistryData("/", true);
            }
            finally {
                zk.destroy();
            }
        }
    }

    public void destroy() throws Exception {
        if (this.serverFactory != null) {
            this.serverFactory.shutdown();
            org.apache.zookeeper.server.ZooKeeperServer zkServer = this.serverFactory.getZooKeeperServer();
            if (zkServer != null && zkServer.isRunning()) {
                zkServer.shutdown();
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Destroyed");
        }
    }

    public String getUserid() {
        return this.userid;
    }

    public void setUserid(String userid) {
        this.userid = userid;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public boolean isPurge() {
        return this.purge;
    }

    public void setPurge(boolean purge) {
        this.purge = purge;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getName() {
        return this.toString();
    }

    public String toString() {
        return "Zoo Keeper Registry Server";
    }

    public String getServiceUri() {
        return this.serviceUri;
    }
}

