/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.state;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConnectionId;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.DestinationInfo;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.ProducerId;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.command.Response;
import org.apache.activemq.command.SessionId;
import org.apache.activemq.command.SessionInfo;
import org.apache.activemq.command.TransactionInfo;
import org.apache.activemq.state.CommandVisitorAdapter;
import org.apache.activemq.state.ConnectionState;
import org.apache.activemq.state.ConsumerState;
import org.apache.activemq.state.ProducerState;
import org.apache.activemq.state.SessionState;
import org.apache.activemq.state.Tracked;
import org.apache.activemq.state.TransactionState;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConnectionStateTracker
extends CommandVisitorAdapter {
    private static final Log LOG = LogFactory.getLog(ConnectionStateTracker.class);
    private static final Tracked TRACKED_RESPONSE_MARKER = new Tracked(null);
    protected final ConcurrentHashMap<ConnectionId, ConnectionState> connectionStates = new ConcurrentHashMap();
    private boolean trackTransactions;
    private boolean restoreSessions = true;
    private boolean restoreConsumers = true;
    private boolean restoreProducers = true;
    private boolean restoreTransaction = true;
    private boolean trackMessages = true;
    private int maxCacheSize = 131072;
    private int currentCacheSize;
    private Map<MessageId, Message> messageCache = new LinkedHashMap<MessageId, Message>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<MessageId, Message> eldest) {
            boolean result;
            boolean bl = result = ConnectionStateTracker.this.currentCacheSize > ConnectionStateTracker.this.maxCacheSize;
            if (result) {
                ConnectionStateTracker.this.currentCacheSize -= eldest.getValue().getSize();
            }
            return result;
        }
    };

    public Tracked track(Command command) throws IOException {
        try {
            return (Tracked)command.visit(this);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable e) {
            throw IOExceptionSupport.create(e);
        }
    }

    public void trackBack(Command command) {
        Message message;
        if (this.trackMessages && command != null && command.isMessage() && (message = (Message)command).getTransactionId() == null) {
            this.currentCacheSize += message.getSize();
        }
    }

    public void restore(Transport transport) throws IOException {
        for (ConnectionState connectionState : this.connectionStates.values()) {
            transport.oneway(connectionState.getInfo());
            this.restoreTempDestinations(transport, connectionState);
            if (this.restoreSessions) {
                this.restoreSessions(transport, connectionState);
            }
            if (!this.restoreTransaction) continue;
            this.restoreTransactions(transport, connectionState);
        }
        for (Message msg : this.messageCache.values()) {
            transport.oneway(msg);
        }
    }

    private void restoreTransactions(Transport transport, ConnectionState connectionState) throws IOException {
        for (TransactionState transactionState : connectionState.getTransactionStates()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("tx: " + transactionState.getId());
            }
            for (Command command : transactionState.getCommands()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("tx replay: " + command);
                }
                transport.oneway(command);
            }
        }
    }

    protected void restoreSessions(Transport transport, ConnectionState connectionState) throws IOException {
        for (SessionState sessionState : connectionState.getSessionStates()) {
            transport.oneway(sessionState.getInfo());
            if (this.restoreProducers) {
                this.restoreProducers(transport, sessionState);
            }
            if (!this.restoreConsumers) continue;
            this.restoreConsumers(transport, sessionState);
        }
    }

    protected void restoreConsumers(Transport transport, SessionState sessionState) throws IOException {
        for (ConsumerState consumerState : sessionState.getConsumerStates()) {
            transport.oneway(consumerState.getInfo());
        }
    }

    protected void restoreProducers(Transport transport, SessionState sessionState) throws IOException {
        for (ProducerState producerState : sessionState.getProducerStates()) {
            transport.oneway(producerState.getInfo());
        }
    }

    protected void restoreTempDestinations(Transport transport, ConnectionState connectionState) throws IOException {
        Iterator<DestinationInfo> iter2 = connectionState.getTempDesinations().iterator();
        while (iter2.hasNext()) {
            transport.oneway(iter2.next());
        }
    }

    public Response processAddDestination(DestinationInfo info) {
        ConnectionState cs;
        if (info != null && (cs = this.connectionStates.get(info.getConnectionId())) != null && info.getDestination().isTemporary()) {
            cs.addTempDestination(info);
        }
        return TRACKED_RESPONSE_MARKER;
    }

    public Response processRemoveDestination(DestinationInfo info) {
        ConnectionState cs;
        if (info != null && (cs = this.connectionStates.get(info.getConnectionId())) != null && info.getDestination().isTemporary()) {
            cs.removeTempDestination(info.getDestination());
        }
        return TRACKED_RESPONSE_MARKER;
    }

    public Response processAddProducer(ProducerInfo info) {
        SessionState ss;
        ConnectionState cs;
        ConnectionId connectionId;
        SessionId sessionId;
        if (info != null && info.getProducerId() != null && (sessionId = info.getProducerId().getParentId()) != null && (connectionId = sessionId.getParentId()) != null && (cs = this.connectionStates.get(connectionId)) != null && (ss = cs.getSessionState(sessionId)) != null) {
            ss.addProducer(info);
        }
        return TRACKED_RESPONSE_MARKER;
    }

    public Response processRemoveProducer(ProducerId id) {
        SessionState ss;
        ConnectionState cs;
        ConnectionId connectionId;
        SessionId sessionId;
        if (id != null && (sessionId = id.getParentId()) != null && (connectionId = sessionId.getParentId()) != null && (cs = this.connectionStates.get(connectionId)) != null && (ss = cs.getSessionState(sessionId)) != null) {
            ss.removeProducer(id);
        }
        return TRACKED_RESPONSE_MARKER;
    }

    public Response processAddConsumer(ConsumerInfo info) {
        SessionState ss;
        ConnectionState cs;
        ConnectionId connectionId;
        SessionId sessionId;
        if (info != null && (sessionId = info.getConsumerId().getParentId()) != null && (connectionId = sessionId.getParentId()) != null && (cs = this.connectionStates.get(connectionId)) != null && (ss = cs.getSessionState(sessionId)) != null) {
            ss.addConsumer(info);
        }
        return TRACKED_RESPONSE_MARKER;
    }

    public Response processRemoveConsumer(ConsumerId id, long lastDeliveredSequenceId) {
        SessionState ss;
        ConnectionState cs;
        ConnectionId connectionId;
        SessionId sessionId;
        if (id != null && (sessionId = id.getParentId()) != null && (connectionId = sessionId.getParentId()) != null && (cs = this.connectionStates.get(connectionId)) != null && (ss = cs.getSessionState(sessionId)) != null) {
            ss.removeConsumer(id);
        }
        return TRACKED_RESPONSE_MARKER;
    }

    public Response processAddSession(SessionInfo info) {
        ConnectionState cs;
        ConnectionId connectionId;
        if (info != null && (connectionId = info.getSessionId().getParentId()) != null && (cs = this.connectionStates.get(connectionId)) != null) {
            cs.addSession(info);
        }
        return TRACKED_RESPONSE_MARKER;
    }

    public Response processRemoveSession(SessionId id, long lastDeliveredSequenceId) {
        ConnectionState cs;
        ConnectionId connectionId;
        if (id != null && (connectionId = id.getParentId()) != null && (cs = this.connectionStates.get(connectionId)) != null) {
            cs.removeSession(id);
        }
        return TRACKED_RESPONSE_MARKER;
    }

    public Response processAddConnection(ConnectionInfo info) {
        if (info != null) {
            this.connectionStates.put(info.getConnectionId(), new ConnectionState(info));
        }
        return TRACKED_RESPONSE_MARKER;
    }

    public Response processRemoveConnection(ConnectionId id, long lastDeliveredSequenceId) throws Exception {
        if (id != null) {
            this.connectionStates.remove(id);
        }
        return TRACKED_RESPONSE_MARKER;
    }

    public Response processMessage(Message send) throws Exception {
        if (send != null) {
            if (this.trackTransactions && send.getTransactionId() != null) {
                TransactionState transactionState;
                ConnectionState cs;
                ConnectionId connectionId = send.getProducerId().getParentId().getParentId();
                if (connectionId != null && (cs = this.connectionStates.get(connectionId)) != null && (transactionState = cs.getTransactionState(send.getTransactionId())) != null) {
                    transactionState.addCommand(send);
                }
                return TRACKED_RESPONSE_MARKER;
            }
            if (this.trackMessages) {
                this.messageCache.put(send.getMessageId(), send.copy());
            }
        }
        return null;
    }

    public Response processBeginTransaction(TransactionInfo info) {
        if (this.trackTransactions && info != null && info.getTransactionId() != null) {
            ConnectionState cs;
            ConnectionId connectionId = info.getConnectionId();
            if (connectionId != null && (cs = this.connectionStates.get(connectionId)) != null) {
                cs.addTransactionState(info.getTransactionId());
                TransactionState state = cs.getTransactionState(info.getTransactionId());
                state.addCommand(info);
            }
            return TRACKED_RESPONSE_MARKER;
        }
        return null;
    }

    public Response processPrepareTransaction(TransactionInfo info) throws Exception {
        if (this.trackTransactions && info != null) {
            TransactionState transactionState;
            ConnectionState cs;
            ConnectionId connectionId = info.getConnectionId();
            if (connectionId != null && (cs = this.connectionStates.get(connectionId)) != null && (transactionState = cs.getTransactionState(info.getTransactionId())) != null) {
                transactionState.addCommand(info);
            }
            return TRACKED_RESPONSE_MARKER;
        }
        return null;
    }

    public Response processCommitTransactionOnePhase(TransactionInfo info) throws Exception {
        TransactionState transactionState;
        ConnectionState cs;
        ConnectionId connectionId;
        if (this.trackTransactions && info != null && (connectionId = info.getConnectionId()) != null && (cs = this.connectionStates.get(connectionId)) != null && (transactionState = cs.getTransactionState(info.getTransactionId())) != null) {
            transactionState.addCommand(info);
            return new Tracked(new RemoveTransactionAction(info));
        }
        return null;
    }

    public Response processCommitTransactionTwoPhase(TransactionInfo info) throws Exception {
        TransactionState transactionState;
        ConnectionState cs;
        ConnectionId connectionId;
        if (this.trackTransactions && info != null && (connectionId = info.getConnectionId()) != null && (cs = this.connectionStates.get(connectionId)) != null && (transactionState = cs.getTransactionState(info.getTransactionId())) != null) {
            transactionState.addCommand(info);
            return new Tracked(new RemoveTransactionAction(info));
        }
        return null;
    }

    public Response processRollbackTransaction(TransactionInfo info) throws Exception {
        TransactionState transactionState;
        ConnectionState cs;
        ConnectionId connectionId;
        if (this.trackTransactions && info != null && (connectionId = info.getConnectionId()) != null && (cs = this.connectionStates.get(connectionId)) != null && (transactionState = cs.getTransactionState(info.getTransactionId())) != null) {
            transactionState.addCommand(info);
            return new Tracked(new RemoveTransactionAction(info));
        }
        return null;
    }

    public Response processEndTransaction(TransactionInfo info) throws Exception {
        if (this.trackTransactions && info != null) {
            TransactionState transactionState;
            ConnectionState cs;
            ConnectionId connectionId = info.getConnectionId();
            if (connectionId != null && (cs = this.connectionStates.get(connectionId)) != null && (transactionState = cs.getTransactionState(info.getTransactionId())) != null) {
                transactionState.addCommand(info);
            }
            return TRACKED_RESPONSE_MARKER;
        }
        return null;
    }

    public boolean isRestoreConsumers() {
        return this.restoreConsumers;
    }

    public void setRestoreConsumers(boolean restoreConsumers) {
        this.restoreConsumers = restoreConsumers;
    }

    public boolean isRestoreProducers() {
        return this.restoreProducers;
    }

    public void setRestoreProducers(boolean restoreProducers) {
        this.restoreProducers = restoreProducers;
    }

    public boolean isRestoreSessions() {
        return this.restoreSessions;
    }

    public void setRestoreSessions(boolean restoreSessions) {
        this.restoreSessions = restoreSessions;
    }

    public boolean isTrackTransactions() {
        return this.trackTransactions;
    }

    public void setTrackTransactions(boolean trackTransactions) {
        this.trackTransactions = trackTransactions;
    }

    public boolean isRestoreTransaction() {
        return this.restoreTransaction;
    }

    public void setRestoreTransaction(boolean restoreTransaction) {
        this.restoreTransaction = restoreTransaction;
    }

    public boolean isTrackMessages() {
        return this.trackMessages;
    }

    public void setTrackMessages(boolean trackMessages) {
        this.trackMessages = trackMessages;
    }

    public int getMaxCacheSize() {
        return this.maxCacheSize;
    }

    public void setMaxCacheSize(int maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
    }

    private class RemoveTransactionAction
    implements Runnable {
        private final TransactionInfo info;

        public RemoveTransactionAction(TransactionInfo info) {
            this.info = info;
        }

        public void run() {
            ConnectionId connectionId = this.info.getConnectionId();
            ConnectionState cs = ConnectionStateTracker.this.connectionStates.get(connectionId);
            cs.removeTransactionState(this.info.getTransactionId());
        }
    }
}

