/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.meshkeeper.distribution.jms;

import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;

public abstract class JMSProvider {
    private HashMap<String, SharedConnection> connectionByHostPort = new HashMap();
    private HashMap<Connection, SharedConnection> connections = new HashMap();

    public abstract ConnectionFactory createConnectionFactory(URI var1);

    public abstract Destination createQueue(String var1);

    public abstract Destination createTopic(String var1);

    public synchronized Connection getConnection(Object ref, URI uri) throws JMSException {
        String hostPort = uri.getHost() + ":" + uri.getPort();
        SharedConnection sc = this.connectionByHostPort.get(hostPort);
        if (sc == null) {
            sc = new SharedConnection();
            sc.hostPort = hostPort;
            sc.connection = this.createConnectionFactory(uri).createConnection();
            sc.connection.start();
            this.connectionByHostPort.put(hostPort, sc);
            this.connections.put(sc.connection, sc);
        }
        return sc.connection;
    }

    public synchronized void releaseConnnection(Connection c, Object ref) {
        SharedConnection sc = this.connections.get(c);
        if (sc == null) {
            return;
        }
        sc.users.remove(ref);
        if (sc.users.isEmpty()) {
            this.connections.remove(c);
            this.connectionByHostPort.remove(sc.hostPort);
        }
        try {
            sc.connection.close();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private class SharedConnection {
        String hostPort;
        Connection connection;
        HashSet<Object> users = new HashSet(1);

        private SharedConnection() {
        }
    }
}

