/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.meshkeeper.distribution.event.jms;

import java.io.Serializable;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import org.fusesource.meshkeeper.MeshEvent;
import org.fusesource.meshkeeper.MeshEventListener;
import org.fusesource.meshkeeper.distribution.event.AbstractEventClient;
import org.fusesource.meshkeeper.distribution.jms.JMSProvider;

public class JMSEventClient
extends AbstractEventClient {
    private static final String topicPrefix = "clevent.";
    private final JMSProvider provider;
    private final Connection connection;
    private final Session sendSession;
    private final MessageProducer sender;
    private final Session listenerSession;
    private final HashMap<String, TopicHandler> listeners = new HashMap();

    JMSEventClient(JMSProvider provider, URI uri) throws JMSException {
        this.provider = provider;
        this.connection = provider.getConnection((Object)this, uri);
        this.sendSession = this.connection.createSession(false, 1);
        this.sender = this.sendSession.createProducer(null);
        this.sender.setDeliveryMode(1);
        this.sender.setTimeToLive(120000L);
        this.listenerSession = this.connection.createSession(false, 1);
    }

    public synchronized void closeEventListener(MeshEventListener listener, String topic) throws Exception {
        TopicHandler th = this.listeners.get(topic);
        if (th != null) {
            th.listeners.remove(listener);
            if (th.listeners.isEmpty()) {
                th.close();
            }
        }
    }

    public synchronized void openEventListener(MeshEventListener listener, String topic) throws Exception {
        TopicHandler th = this.listeners.get(topic);
        if (th == null) {
            th = new TopicHandler(topic);
            this.listeners.put(topic, th);
        }
        th.addListener(listener);
    }

    public synchronized void sendEvent(MeshEvent event, String topic) throws Exception {
        this.sender.send((Destination)this.sendSession.createTopic(topicPrefix + topic), (Message)this.sendSession.createObjectMessage((Serializable)event));
    }

    public void start() {
    }

    public synchronized void destroy() throws Exception {
        this.sendSession.close();
        this.listenerSession.close();
        this.listeners.clear();
        this.provider.releaseConnnection(this.connection, (Object)this);
    }

    private class TopicHandler
    implements MessageListener {
        private HashSet<MeshEventListener> listeners = new HashSet(1);
        private final MessageConsumer consumer;

        TopicHandler(String topic) throws JMSException {
            this.consumer = JMSEventClient.this.listenerSession.createConsumer((Destination)JMSEventClient.this.listenerSession.createTopic(JMSEventClient.topicPrefix + topic));
            this.consumer.setMessageListener((MessageListener)this);
        }

        public synchronized void addListener(MeshEventListener listener) {
            this.listeners.add(listener);
        }

        public synchronized void close() throws JMSException {
            this.consumer.close();
        }

        public synchronized void onMessage(Message msg) {
            for (MeshEventListener l : this.listeners) {
                try {
                    MeshEvent event = (MeshEvent)((ObjectMessage)msg).getObject();
                    l.onEvent(event);
                }
                catch (JMSException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

