/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.meshkeeper.distribution.remoting.rmiviajms;

import java.net.URI;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import org.fusesource.meshkeeper.distribution.jms.JMSClientFactory;
import org.fusesource.meshkeeper.distribution.jms.JMSProvider;
import org.fusesource.meshkeeper.util.internal.URISupport;
import org.fusesource.rmiviajms.internal.JMSRemoteSystem;

public class MeshKeeperRemoteJMSSystem
extends JMSRemoteSystem {
    public static final String QUEUE_PREFIX = System.getProperty("org.fusesource.rmiviajms.QUEUE_PREFIX", "rmiviajms.");
    static String PROVIDER_URI = "rmiviajms:activemq:tcp://0.0.0.0:0";
    private static JMSProvider provider;
    private static URI CONNECT_URI;
    private static AtomicInteger remoteSysRefCount;

    public static void addRef() {
        remoteSysRefCount.incrementAndGet();
    }

    public static void removeRef() {
        if (remoteSysRefCount.decrementAndGet() == 0) {
            try {
                INSTANCE.reset();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    static void initialize(String providerUri) throws Exception {
        PROVIDER_URI = providerUri;
        provider = (JMSProvider)new JMSClientFactory().create(PROVIDER_URI);
        CONNECT_URI = URISupport.stripScheme((URI)new URI(PROVIDER_URI));
    }

    protected ConnectionFactory createConnectionFactory() {
        try {
            return provider.createConnectionFactory(CONNECT_URI);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Error creating rmi connection factory", e);
        }
    }

    protected Destination createQueue(String systemId) {
        try {
            return provider.createQueue(QUEUE_PREFIX + systemId);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Error creating rmi destination", e);
        }
    }

    protected Destination createTopic(String systemId) {
        try {
            return provider.createTopic(QUEUE_PREFIX + systemId);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Error creating rmi destination", e);
        }
    }

    public String toString() {
        return "MeshKeeperRemoteSystem at " + PROVIDER_URI;
    }

    static {
        remoteSysRefCount = new AtomicInteger(0);
    }
}

