/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.meshkeeper.distribution.remoting.rmiviajms;

import java.rmi.Remote;
import java.util.concurrent.atomic.AtomicBoolean;
import org.fusesource.meshkeeper.Oneway;
import org.fusesource.meshkeeper.distribution.remoting.AbstractRemotingClient;
import org.fusesource.meshkeeper.distribution.remoting.rmiviajms.MeshKeeperRemoteJMSSystem;
import org.fusesource.rmiviajms.JMSRemoteObject;
import org.fusesource.rmiviajms.internal.JMSRemoteSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RmiViaJmsExporter
extends AbstractRemotingClient {
    String providerUri;
    private AtomicBoolean started = new AtomicBoolean(false);

    RmiViaJmsExporter() {
    }

    protected <T> T exportInterfaces(T obj, String multiCastAddress, Class<?>[] interfaces) throws Exception {
        if (multiCastAddress != null) {
            return (T)JMSRemoteObject.export(obj, (String)("multicast:" + multiCastAddress), (Class[])interfaces);
        }
        return (T)JMSRemoteObject.export(obj, (Class[])interfaces);
    }

    public <T> T getMulticastProxy(String address, Class<?> mainInterface, Class<?> ... interfaces) throws Exception {
        return (T)JMSRemoteObject.toProxy((String)("multicast:" + address), mainInterface, (Class[])interfaces);
    }

    public void unexport(Object obj) throws Exception {
        if (obj instanceof Remote) {
            JMSRemoteObject.unexportObject((Remote)((Remote)obj), (boolean)true);
        }
    }

    public void setProviderUri(String providerUri) {
        this.providerUri = providerUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        if (this.started.compareAndSet(false, true)) {
            System.setProperty("org.fusesource.rmiviajms.REMOTE_SYSTEM_CLASS", MeshKeeperRemoteJMSSystem.class.getName());
            ClassLoader original = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(RmiViaJmsExporter.class.getClassLoader());
            try {
                MeshKeeperRemoteJMSSystem.addRef();
                MeshKeeperRemoteJMSSystem.initialize(this.providerUri);
                JMSRemoteObject.addOneWayAnnotation(Oneway.class);
            }
            finally {
                Thread.currentThread().setContextClassLoader(original);
            }
        }
    }

    public void setUserClassLoader(ClassLoader loader) {
        JMSRemoteSystem.INSTANCE.setUserClassLoader(loader);
    }

    public void destroy() throws InterruptedException, Exception {
        if (this.started.compareAndSet(true, false)) {
            MeshKeeperRemoteJMSSystem.removeRef();
        }
    }

    public String toString() {
        return "RmiViaJmsExporter at " + MeshKeeperRemoteJMSSystem.PROVIDER_URI;
    }
}

