/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.meshkeeper.distribution.repository.wagon;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.repository.Repository;
import org.apache.maven.wagon.shared.http.AbstractHttpClientWagon;
import org.apache.maven.wagon.shared.http.HttpConfiguration;
import org.apache.maven.wagon.shared.http.HttpMethodConfiguration;
import org.fusesource.meshkeeper.MeshArtifact;
import org.fusesource.meshkeeper.distribution.repository.AbstractRepositoryClient;
import org.fusesource.meshkeeper.distribution.repository.AuthenticationInfo;
import org.fusesource.meshkeeper.distribution.repository.wagon.WagonResource;
import org.fusesource.meshkeeper.util.internal.FileSupport;

public class WagonResourceManager
extends AbstractRepositoryClient {
    private Wagon localWagon;
    private static final HashMap<String, Class<? extends Wagon>> wagonProviders = new HashMap();
    private HashMap<String, Wagon> connectedRepos = new HashMap();

    private static void registerWagonClass(String protocol, String classname) {
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(classname);
            wagonProviders.put(protocol, clazz);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MeshArtifact createResource() {
        return new WagonResource();
    }

    public void setLocalRepoDir(String localRepoDir) throws Exception {
        File dir = new File(localRepoDir);
        Repository localRepo = new Repository("local", dir.toURI().toString());
        if (!dir.exists()) {
            dir.mkdirs();
        }
        this.localWagon = this.connectWagon(localRepo, null);
    }

    public File getLocalRepoDirectory() {
        return new File(this.localWagon.getRepository().getBasedir());
    }

    public void setCentralRepoUri(String url, AuthenticationInfo authInfo) throws Exception {
        Repository remoteRepo = new Repository("common", url);
        this.connectWagon(remoteRepo, authInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolveResource(MeshArtifact resource) throws Exception {
        block13: {
            Wagon w = null;
            long timestamp = 0L;
            if (this.localWagon.resourceExists(resource.getRepositoryPath())) {
                timestamp = new File(this.localWagon.getRepository().getBasedir() + File.separator + resource.getRepositoryPath()).lastModified();
            } else {
                WagonResourceManager wagonResourceManager = this;
                synchronized (wagonResourceManager) {
                    w = this.connectedRepos.get(resource.getRepositoryId());
                    if (w == null) {
                        Repository remote = new Repository(resource.getRepositoryId(), resource.getRepositoryUri());
                        w = this.connectWagon(remote, null);
                    }
                }
                if (w != null && w.resourceExists(resource.getRepositoryPath())) {
                    try {
                        if (resource.getType() == 1) {
                            String path = resource.getRepositoryPath();
                            if (!path.endsWith("/")) {
                                path = path + "/";
                            }
                            WagonResourceManager.downloadDirectory(w, new File(this.localWagon.getRepository().getBasedir()), path);
                            break block13;
                        }
                        w.getIfNewer(resource.getRepositoryPath(), new File(this.localWagon.getRepository().getBasedir(), resource.getRepositoryPath()), timestamp);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else if (timestamp == 0L) {
                    throw new Exception("Resource not found: " + resource.getRepositoryPath());
                }
            }
        }
        resource.setLocalPath(this.localWagon.getRepository().getBasedir() + File.separator + resource.getRepositoryPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deployFile(MeshArtifact resource, byte[] data) throws Exception {
        File f = File.createTempFile("tmp", "dat");
        FileOutputStream fw = new FileOutputStream(f);
        fw.write(data);
        fw.flush();
        fw.close();
        try {
            this.deployResource(resource, f);
        }
        finally {
            f.delete();
        }
    }

    public void deployDirectory(MeshArtifact resource, File d) throws Exception {
        this.deployResource(resource, d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deployResource(MeshArtifact resource, File f) throws Exception {
        Wagon w = null;
        WagonResourceManager wagonResourceManager = this;
        synchronized (wagonResourceManager) {
            w = this.connectedRepos.get(resource.getRepositoryId());
            if (w == null) {
                Repository remote = new Repository(resource.getRepositoryId(), resource.getRepositoryUri());
                w = this.connectWagon(remote, null);
            }
        }
        w.put(f, resource.getRepositoryPath());
    }

    private Wagon connectWagon(Repository repo, AuthenticationInfo authInfo) throws Exception {
        Class<? extends Wagon> wagonClass = wagonProviders.get(repo.getProtocol());
        Wagon w = wagonClass.newInstance();
        if (w instanceof AbstractHttpClientWagon) {
            HttpConfiguration hc = new HttpConfiguration();
            HttpMethodConfiguration hmc = new HttpMethodConfiguration();
            hmc.setUseDefaultHeaders(false);
            hmc.addHeader("Cache-control", "no-cache");
            hmc.addHeader("Cache-store", "no-store");
            hmc.addHeader("Pragma", "no-cache");
            hmc.addHeader("Expires", "0");
            hc.setAll(hmc);
            ((AbstractHttpClientWagon)w).setHttpConfiguration(hc);
        }
        w.connect(repo, WagonResourceManager.convertAuthInfo(authInfo));
        this.connectedRepos.put(repo.getName(), w);
        return w;
    }

    private static final void downloadDirectory(Wagon source, File targetDir, String path) throws Exception {
        Iterator i = source.getFileList(path).iterator();
        if (!i.hasNext()) {
            File target = new File(targetDir, path);
            target.mkdirs();
        } else {
            while (i.hasNext()) {
                String file = (String)i.next();
                if (file.endsWith("/")) {
                    WagonResourceManager.downloadDirectory(source, targetDir, path + file);
                    continue;
                }
                WagonResourceManager.downloadFile(source, targetDir, path + file);
            }
        }
    }

    private static final void downloadFile(Wagon source, File targetDir, String name) throws IOException, TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        File target = new File(targetDir, name);
        source.get(name, new File(targetDir, name));
        if (!target.exists()) {
            target.createNewFile();
        }
    }

    public void purgeLocalRepo() throws IOException {
        FileSupport.recursiveDelete((String)this.localWagon.getRepository().getBasedir());
    }

    public void start() {
    }

    public void destroy() {
        for (Wagon w : this.connectedRepos.values()) {
            try {
                w.disconnect();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        this.connectedRepos.clear();
    }

    private static org.apache.maven.wagon.authentication.AuthenticationInfo convertAuthInfo(AuthenticationInfo info) {
        if (info == null) {
            return null;
        }
        org.apache.maven.wagon.authentication.AuthenticationInfo rc = new org.apache.maven.wagon.authentication.AuthenticationInfo();
        rc.setPassphrase(info.getPassphrase());
        rc.setPassword(info.getPassword());
        rc.setPrivateKey(info.getPrivateKey());
        rc.setUserName(info.getUserName());
        return rc;
    }

    static {
        WagonResourceManager.registerWagonClass("file", "org.apache.maven.wagon.providers.file.FileWagon");
        WagonResourceManager.registerWagonClass("ftp", "org.apache.maven.wagon.providers.ftp.FtpWagon");
        WagonResourceManager.registerWagonClass("http", "org.apache.maven.wagon.providers.http.HttpWagon");
        WagonResourceManager.registerWagonClass("dav", "org.apache.maven.wagon.providers.webdav.WebDavWagon");
    }
}

