/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.meshkeeper;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.fusesource.meshkeeper.MeshArtifact;
import org.fusesource.meshkeeper.distribution.PluginClassLoader;
import org.fusesource.meshkeeper.util.internal.ProcessSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Expression
implements Serializable {
    private static final long serialVersionUID = 1L;

    public final String evaluate() {
        return this.evaluate(System.getProperties());
    }

    public abstract String evaluate(Properties var1);

    public static PropertyExpression property(String name) {
        return new PropertyExpression(name, null);
    }

    public static PropertyExpression property(String name, Expression defaultExpression) {
        return new PropertyExpression(name, defaultExpression);
    }

    public static SystemPropertyExpression sysProperty(String name, Expression defaultExpression) {
        return new SystemPropertyExpression(name, defaultExpression);
    }

    public static StringExpression string(String value) {
        return new StringExpression(value);
    }

    public static StringExpression[] string(String ... args) {
        if (args == null) {
            return null;
        }
        StringExpression[] rc = new StringExpression[args.length];
        for (int i = 0; i < rc.length; ++i) {
            rc[i] = Expression.string(args[i]);
        }
        return rc;
    }

    public static FileExpression file(String value) {
        return new FileExpression(Expression.string(value));
    }

    public static FileExpression file(Expression value) {
        return new FileExpression(value);
    }

    public static FileExpression[] file(String ... value) {
        return Expression.file(Expression.string(value));
    }

    public static FileExpression[] file(Expression ... value) {
        if (value == null) {
            return null;
        }
        FileExpression[] rc = new FileExpression[value.length];
        for (int i = 0; i < rc.length; ++i) {
            rc[i] = Expression.file(value[i]);
        }
        return rc;
    }

    public static PathExpression path(List<FileExpression> list) {
        return new PathExpression(list);
    }

    public static PathExpression path(FileExpression ... value) {
        List<FileExpression> list = Arrays.asList(value);
        return Expression.path(list);
    }

    public static ExecExpression exec(List<Expression> value) {
        return new ExecExpression(value);
    }

    public static MopExpression mop(String artifactId) {
        return new MopExpression(artifactId);
    }

    public static AppendExpression append(List<Expression> list) {
        return new AppendExpression(list);
    }

    public static AppendExpression append(Expression ... value) {
        List<Expression> list = Arrays.asList(value);
        return Expression.append(list);
    }

    public static FileExpression resource(MeshArtifact resource) {
        return new FileExpression(Expression.append(Expression.property("org.fusesource.testrunner.localRepoDir", Expression.string("local-repo")), Expression.file(File.separator + resource.getRepositoryPath())));
    }

    public String toString() {
        return this.evaluate();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AppendExpression
    extends Expression {
        private static final long serialVersionUID = 1L;
        final ArrayList<Expression> parts = new ArrayList();

        public AppendExpression(Collection<Expression> parts) {
            this.parts.addAll(parts);
        }

        @Override
        public String evaluate(Properties p) {
            StringBuilder sb = new StringBuilder();
            for (Expression expression : this.parts) {
                sb.append(expression.evaluate(p));
            }
            return sb.toString();
        }
    }

    public static class MopExpression
    extends Expression {
        private static final long serialVersionUID = 1L;
        private String artifactId;

        public MopExpression(String artifactId) {
            this.artifactId = artifactId;
        }

        public String evaluate(Properties p) {
            try {
                return PluginClassLoader.getDefaultPluginLoader().getPluginResolver().resolveClassPath(this.artifactId);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExecExpression
    extends Expression {
        private static final long serialVersionUID = 1L;
        private final List<Expression> args;

        public ExecExpression(List<Expression> args) {
            this.args = args;
        }

        @Override
        public String evaluate(Properties p) {
            String[] cmdline = new String[this.args.size()];
            for (int i = 0; i < cmdline.length; ++i) {
                cmdline[i] = this.args.get(i).evaluate(p);
            }
            try {
                Process process = Runtime.getRuntime().exec(cmdline);
                if (process == null) {
                    throw new RuntimeException("Could not execute " + cmdline[0]);
                }
                String rc = ProcessSupport.caputure(process);
                if (rc == null) {
                    throw new RuntimeException("Command " + cmdline[0] + " failed");
                }
                return rc;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PathExpression
    extends Expression {
        private static final long serialVersionUID = 1L;
        final ArrayList<FileExpression> files = new ArrayList();

        public PathExpression(Collection<FileExpression> files) {
            this.files.addAll(files);
        }

        @Override
        public String evaluate(Properties p) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (FileExpression file : this.files) {
                if (!first) {
                    sb.append(File.pathSeparatorChar);
                }
                first = false;
                sb.append(file.evaluate(p));
            }
            return sb.toString();
        }
    }

    public static class FileExpression
    extends Expression {
        private static final long serialVersionUID = 1L;
        Expression name;

        public FileExpression(Expression name) {
            this.name = name;
        }

        public String evaluate(Properties p) {
            String t = this.name.evaluate(p);
            if ('/' != File.separatorChar) {
                t.replace('/', File.separatorChar);
            } else {
                t.replace('\\', File.separatorChar);
            }
            return t;
        }
    }

    public static class PropertyExpression
    extends Expression {
        private static final long serialVersionUID = 1L;
        String name;
        Expression defaultExpression;

        public PropertyExpression(String name, Expression defaultExpression) {
            this.name = name;
            this.defaultExpression = defaultExpression;
        }

        public String evaluate(Properties p) {
            String rc = p.getProperty(this.name);
            if (rc == null && this.defaultExpression != null) {
                rc = this.defaultExpression.evaluate(p);
            }
            return rc;
        }
    }

    public static class SystemPropertyExpression
    extends Expression {
        private static final long serialVersionUID = 1L;
        String name;
        Expression defaultExpression;

        public SystemPropertyExpression(String name, Expression defaultExpression) {
            this.name = name;
            this.defaultExpression = defaultExpression;
        }

        public String evaluate(Properties p) {
            String value = p.getProperty(this.name);
            if (value == null && this.defaultExpression != null) {
                value = this.defaultExpression.evaluate(p);
            }
            if (value == null) {
                return "";
            }
            return "-D" + this.name + "=" + value;
        }
    }

    public static class StringExpression
    extends Expression {
        private static final long serialVersionUID = 1L;
        String value;

        public StringExpression(String value) {
            this.value = value;
        }

        public String evaluate(Properties p) {
            return this.value;
        }
    }
}

