/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.meshkeeper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.fusesource.meshkeeper.Expression;
import org.fusesource.meshkeeper.LaunchDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaLaunch {
    private Expression jvm = Expression.string("java");
    Expression classpath;
    Expression.FileExpression workingDir;
    Expression mainClass;
    ArrayList<Expression> jvmArgs = new ArrayList();
    ArrayList<Expression> args = new ArrayList();
    ArrayList<Expression> systemProperties = new ArrayList();
    String bootStrapClassLoaderFactoryPath;

    public Expression getJvm() {
        return this.jvm;
    }

    public void setJvm(String jvm) {
        this.jvm = Expression.string(jvm);
    }

    public void setJvm(Expression jvm) {
        this.jvm = jvm;
    }

    public List<Expression> getJvmArgs() {
        return this.jvmArgs;
    }

    public JavaLaunch addJvmArgs(String ... args) {
        return this.addJvmArgs(Expression.string(args));
    }

    public JavaLaunch addJvmArgs(Expression ... args) {
        return this.addJvmArgs(Arrays.asList(args));
    }

    public JavaLaunch addJvmArgs(List<Expression> args) {
        this.jvmArgs.addAll(args);
        return this;
    }

    public JavaLaunch addSystemProperty(Expression.SystemPropertyExpression expression) {
        this.systemProperties.add(expression);
        return this;
    }

    public JavaLaunch addSystemProperty(String key, String value) {
        this.systemProperties.add(Expression.string("-D" + key + "=" + value));
        return this;
    }

    public JavaLaunch addSystemProperty(Expression key, Expression value) {
        this.systemProperties.add(Expression.append(Expression.string("-D"), key, Expression.string("="), value));
        return this;
    }

    public JavaLaunch propagateSystemProperties(Properties sourceProps, String ... names) {
        for (String name : names) {
            if (sourceProps.getProperty(name) == null) continue;
            this.addSystemProperty(name, sourceProps.getProperty(name));
        }
        return this;
    }

    public Expression getClasspath() {
        return this.classpath;
    }

    public void setBootstrapClassLoaderFactory(String bootStrapClassLoaderFactoryPath) {
        this.bootStrapClassLoaderFactoryPath = bootStrapClassLoaderFactoryPath;
    }

    public void setClasspath(Expression classpath) {
        this.classpath = classpath;
    }

    public void setClasspath(Expression.FileExpression ... classpath) {
        this.classpath = Expression.path(classpath);
    }

    public void setClasspath(String ... classpath) {
        this.classpath = Expression.path(Expression.file(classpath));
    }

    public Expression.FileExpression getWorkingDir() {
        return this.workingDir;
    }

    public void setWorkingDir(String workingDir) {
        this.workingDir = Expression.file(workingDir);
    }

    public void setWorkingDir(Expression.FileExpression workingDir) {
        this.workingDir = workingDir;
    }

    public Expression getMainClass() {
        return this.mainClass;
    }

    public void setMainClass(String mainClass) {
        this.mainClass = Expression.string(mainClass);
    }

    public void setMainClass(Expression mainClass) {
        this.mainClass = mainClass;
    }

    public ArrayList<Expression> args() {
        return this.args;
    }

    public JavaLaunch addArgs(String ... args) {
        return this.addArgs(Expression.string(args));
    }

    public JavaLaunch addArgs(Expression ... args) {
        return this.addArgs(Arrays.asList(args));
    }

    public JavaLaunch addArgs(List<Expression> args) {
        this.args.addAll(args);
        return this;
    }

    public LaunchDescription toLaunchDescription() {
        LaunchDescription ld = new LaunchDescription();
        ld.setWorkingDirectory(this.workingDir);
        ld.add(this.jvm);
        ld.add(this.jvmArgs);
        ld.add(this.systemProperties);
        if (this.classpath != null || this.bootStrapClassLoaderFactoryPath != null) {
            ld.add(Expression.string("-cp"));
            Expression launchClasspath = null;
            if (this.bootStrapClassLoaderFactoryPath != null) {
                ld.addPreLaunchTask(new LaunchDescription.BootstrapClassPathTask(this.bootStrapClassLoaderFactoryPath));
                launchClasspath = Expression.file((Expression)Expression.property("bootstrap.classpath", Expression.string("")));
            }
            if (this.classpath != null) {
                launchClasspath = launchClasspath == null ? this.classpath : Expression.path(Expression.file(launchClasspath), Expression.file(this.classpath));
            }
            ld.add(launchClasspath);
        }
        ld.add(this.mainClass);
        ld.add(this.args);
        return ld;
    }
}

