/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.meshkeeper;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import org.fusesource.meshkeeper.Expression;
import org.fusesource.meshkeeper.LaunchTask;
import org.fusesource.meshkeeper.MeshArtifact;
import org.fusesource.meshkeeper.MeshProcessListener;
import org.fusesource.meshkeeper.classloader.ClassLoaderFactory;
import org.fusesource.meshkeeper.launcher.LocalProcess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LaunchDescription
implements Serializable {
    private static final long serialVersionUID = 1L;
    ArrayList<Expression> command = new ArrayList();
    HashMap<String, Expression> environment;
    Expression.FileExpression workingDirectory;
    ArrayList<LaunchTask> preLaunchTasks = new ArrayList();

    public LaunchDescription add(String ... values) {
        return this.add(Expression.string(values));
    }

    public LaunchDescription add(Expression ... value) {
        return this.add(Arrays.asList(value));
    }

    public LaunchDescription add(List<Expression> value) {
        this.command.addAll(value);
        return this;
    }

    public LaunchDescription setEnv(String key, String value) {
        return this.setEnv(key, Expression.string(value));
    }

    public LaunchDescription setEnv(String key, Expression value) {
        if (this.environment == null) {
            this.environment = new HashMap();
        }
        this.environment.put(key, value);
        return this;
    }

    public void propagateSystemProperties(Properties sourceProps, String ... names) {
        for (String name : names) {
            if (sourceProps.getProperty(name) == null) continue;
            this.add("-D" + name + "=" + sourceProps.getProperty(name));
        }
    }

    void addPreLaunchTask(LaunchTask task) {
        this.preLaunchTasks.add(task);
    }

    public void installResource(MeshArtifact resource) {
        this.preLaunchTasks.add(new InstallLaunchResourceTask(resource));
    }

    public void setup(LaunchDescription launch) {
        this.preLaunchTasks.add(new SubLaunchTask(launch));
    }

    public Expression.FileExpression getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(Expression.FileExpression workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = Expression.file(workingDirectory);
    }

    public ArrayList<Expression> getCommand() {
        return this.command;
    }

    public HashMap<String, Expression> getEnvironment() {
        return this.environment;
    }

    public ArrayList<LaunchTask> getPreLaunchTasks() {
        return this.preLaunchTasks;
    }

    private static class SubLaunchTask
    implements Serializable,
    LaunchTask,
    MeshProcessListener {
        private static final long serialVersionUID = 1L;
        private final LaunchDescription launch;
        private transient CountDownLatch done = new CountDownLatch(1);
        private transient LocalProcess process;
        private transient Exception error;

        public SubLaunchTask(LaunchDescription launch) {
            this.launch = launch;
        }

        public void execute(LocalProcess process) throws Exception {
            this.process = process;
            process.getProcessLauncher().launch(this.launch, process.getOwnerRegistryPath(), this);
            this.done.await();
            if (this.error != null) {
                throw this.error;
            }
        }

        public void onProcessExit(int exitCode) {
            if (exitCode != 0) {
                this.error = new Exception("Sub process failed. exit code:" + exitCode);
            }
            this.done.countDown();
        }

        public void onProcessError(Throwable thrown) {
            this.error = new Exception("Sub process failed", thrown);
        }

        public void onProcessInfo(String message) {
            MeshProcessListener listener = this.process.getListener();
            if (listener != null) {
                listener.onProcessInfo(message);
            }
        }

        public void onProcessOutput(int fd, byte[] output) {
            MeshProcessListener listener = this.process.getListener();
            if (listener != null) {
                listener.onProcessOutput(fd, output);
            }
        }
    }

    static class BootstrapClassPathTask
    implements Serializable,
    LaunchTask {
        public static final String BOOTSTRAP_CP_PROPERTY = "bootstrap.classpath";
        private static final long serialVersionUID = 1L;
        private final String classLoaderPath;

        public BootstrapClassPathTask(String classLoaderPath) {
            this.classLoaderPath = classLoaderPath;
        }

        public void execute(LocalProcess process) throws Exception {
            ClassLoaderFactory clf = (ClassLoaderFactory)process.getProcessLauncher().getMeshKeeper().registry().getRegistryObject(this.classLoaderPath);
            process.getListener().onProcessInfo("Setting up bootstrap classpath from: " + this.classLoaderPath);
            URLClassLoader classloader = (URLClassLoader)clf.createClassLoader(this.getClass().getClassLoader(), new File(process.getProcessLauncher().getHostProperties().getDirectory() + File.separator + "classloaer-cache"));
            Expression classpath = null;
            for (URL url : classloader.getURLs()) {
                if ("file".equals(url.getProtocol())) {
                    if (classpath == null) {
                        classpath = Expression.file(new File(url.toURI()).getAbsolutePath());
                    }
                } else {
                    throw new Exception("Can't bootstrap url classpath elements: " + url);
                }
                classpath = Expression.path(Expression.file(classpath), Expression.file(new File(url.toURI()).getAbsolutePath()));
            }
            if (classpath != null) {
                process.getProcessProperties().put(BOOTSTRAP_CP_PROPERTY, classpath.evaluate());
            } else {
                process.getListener().onProcessInfo("No urls found to bootstrap for: " + this.classLoaderPath);
            }
        }
    }

    private static class InstallLaunchResourceTask
    implements Serializable,
    LaunchTask {
        private static final long serialVersionUID = 1L;
        private final MeshArtifact resource;

        public InstallLaunchResourceTask(MeshArtifact resource) {
            this.resource = resource;
        }

        public void execute(LocalProcess process) throws Exception {
            process.getProcessLauncher().getMeshKeeper().repository().resolveResource(this.resource);
        }
    }
}

