/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.meshkeeper;

import java.io.File;
import org.fusesource.meshkeeper.MeshKeeper;
import org.fusesource.meshkeeper.MeshKeeperFactory;
import org.fusesource.meshkeeper.util.internal.FileSupport;

public class MavenTestSupport {
    public static final String SLASH = File.separator;

    public static MeshKeeper createMeshKeeper() throws Exception {
        return MavenTestSupport.createMeshKeeper(null);
    }

    public static MeshKeeper createMeshKeeper(String testName) throws Exception {
        File dataDirectory = MavenTestSupport.getDataDirectory(testName);
        if (System.getProperty("meshkeeper.base") == null) {
            System.setProperty("meshkeeper.base", dataDirectory.getCanonicalPath());
        }
        if (System.getProperty("mop.base") == null) {
            System.setProperty("mop.base", new File(MavenTestSupport.getDataDirectory(null), "mop").getCanonicalPath());
        }
        return MeshKeeperFactory.createMeshKeeper();
    }

    public static File getBaseDirectory() {
        return new File(System.getProperty("basedir", "."));
    }

    public static File getDataDirectory() {
        return MavenTestSupport.getDataDirectory(null);
    }

    public static File getDataDirectory(String testName) {
        return new File(MavenTestSupport.getBaseDirectory(), "target" + SLASH + MavenTestSupport.getRelativeDataDirectory(testName));
    }

    public static String getRelativeDataDirectory(String testName) {
        if (testName == null) {
            testName = "meshkeeper";
        }
        return "test-data" + SLASH + testName;
    }

    public static boolean deleteDataDirectory() {
        return MavenTestSupport.deleteDataDirectory(null);
    }

    public static boolean deleteDataDirectory(String testName) {
        return FileSupport.recursiveDelete(MavenTestSupport.getDataDirectory(testName));
    }
}

