/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.meshkeeper;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.fusesource.meshkeeper.HostProperties;
import org.fusesource.meshkeeper.JavaLaunch;
import org.fusesource.meshkeeper.LaunchDescription;
import org.fusesource.meshkeeper.MeshArtifact;
import org.fusesource.meshkeeper.MeshContainer;
import org.fusesource.meshkeeper.MeshEvent;
import org.fusesource.meshkeeper.MeshEventListener;
import org.fusesource.meshkeeper.MeshProcess;
import org.fusesource.meshkeeper.MeshProcessListener;
import org.fusesource.meshkeeper.RegistryWatcher;
import org.fusesource.meshkeeper.classloader.ClassLoaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface MeshKeeper {
    public String getRegistryConnectUri();

    public void start() throws Exception;

    public void destroy() throws Exception;

    public String setUUID(String var1);

    public String getUUID();

    public <T, S extends T> DistributionRef<T> distribute(String var1, boolean var2, S var3, Class<?> ... var4) throws Exception;

    public void undistribute(Object var1) throws Exception;

    public ScheduledExecutorService getExecutorService();

    public void setUserClassLoader(ClassLoader var1);

    public ClassLoader getUserClassLoader();

    public Registry registry();

    public Remoting remoting();

    public Eventing eventing();

    public Repository repository();

    public Launcher launcher();

    public static interface Repository {
        public MeshArtifact createResource();

        public void resolveResource(MeshArtifact var1) throws Exception;

        public void deployFile(MeshArtifact var1, byte[] var2) throws Exception;

        public void deployDirectory(MeshArtifact var1, File var2) throws Exception;

        public File getLocalRepoDirectory();

        public void purgeLocalRepo() throws IOException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Remoting {
        public <T> T export(T var1, Class<?> ... var2) throws Exception;

        public <T> T exportMulticast(T var1, String var2, Class<?> ... var3) throws Exception;

        public <T> T getMulticastProxy(String var1, Class<?> var2, Class<?> ... var3) throws Exception;

        public void unexport(Object var1) throws Exception;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Registry {
        public static final String MESH_KEEPER_ROOT = "/meshkeeper";

        public String addRegistryObject(String var1, boolean var2, Serializable var3) throws Exception;

        public <T> T getRegistryObject(String var1) throws Exception;

        public byte[] getRegistryData(String var1) throws Exception;

        public void removeRegistryData(String var1, boolean var2) throws Exception;

        public String addRegistryData(String var1, boolean var2, byte[] var3) throws Exception;

        public void addRegistryWatcher(String var1, RegistryWatcher var2) throws Exception;

        public void removeRegistryWatcher(String var1, RegistryWatcher var2) throws Exception;

        public <T> Collection<T> waitForRegistrations(String var1, int var2, long var3) throws TimeoutException, Exception;

        public <T> T waitForRegistration(String var1, long var2) throws TimeoutException, Exception;

        public Collection<String> list(String var1, boolean var2, String ... var3) throws Exception;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Launcher {
        public static final String LAUNCHER_REGISTRY_PATH = "/meshkeeper/launchclients";
        public static final String MESHCONTAINER_REGISTRY_PATH = "/meshkeeper/meshcontainers";

        public List<Integer> reserveTcpPorts(String var1, int var2) throws Exception;

        public void releasePorts(String var1, Collection<Integer> var2) throws Exception;

        public void releaseAllPorts(String var1) throws Exception;

        public void waitForAvailableAgents(long var1) throws InterruptedException, TimeoutException;

        public void waitForAvailableAgents(int var1, long var2, TimeUnit var4) throws InterruptedException, TimeoutException;

        public HostProperties[] getAvailableAgents();

        public void bindAgent(String var1) throws Exception;

        public void releaseAgent(String var1) throws Exception;

        public void releaseAllAgents() throws Exception;

        public MeshProcess launchProcess(String var1, LaunchDescription var2, MeshProcessListener var3) throws Exception;

        public void println(MeshProcess var1, String var2);

        public JavaLaunch createMeshContainerLaunch() throws Exception;

        public JavaLaunch createBootstrapJavaLaunch(String var1, String ... var2) throws Exception;

        public LaunchDescription createLaunchDescription();

        public JavaLaunch createJavaLaunch(String var1, String ... var2);

        public MeshContainer launchMeshContainer(String var1) throws Exception;

        public MeshContainer launchMeshContainer(String var1, MeshProcessListener var2) throws Exception;

        public MeshContainer launchMeshContainer(String var1, JavaLaunch var2, MeshProcessListener var3) throws Exception;

        public void setBootstrapClassLoader(ClassLoader var1) throws Exception;

        public ClassLoader getBootstrapClassLoader();

        public void setBootstrapClassLoaderFactory(ClassLoaderFactory var1);

        public ClassLoaderFactory getBootstrapClassLoaderFactory();

        public long getBindTimeout();

        public void setBindTimeout(long var1);

        public long getLaunchTimeout();

        public void setLaunchTimeout(long var1);

        public long getKillTimeout();

        public void setKillTimeout(long var1);
    }

    public static interface Eventing {
        public void sendEvent(MeshEvent var1, String var2) throws Exception;

        public void openEventListener(MeshEventListener var1, String var2) throws Exception;

        public void closeEventListener(MeshEventListener var1, String var2) throws Exception;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface DistributionRef<D> {
        public String getRegistryPath();

        public D getProxy();

        public D getTarget();
    }
}

