/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.meshkeeper;

import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import org.fusesource.meshkeeper.MeshKeeper;
import org.fusesource.meshkeeper.control.ControlServer;
import org.fusesource.meshkeeper.distribution.DefaultDistributor;
import org.fusesource.meshkeeper.distribution.DistributorFactory;
import org.fusesource.meshkeeper.distribution.provisioner.Provisioner;
import org.fusesource.meshkeeper.distribution.provisioner.ProvisionerFactory;
import org.fusesource.meshkeeper.launcher.LaunchAgent;
import org.fusesource.meshkeeper.launcher.MeshContainer;
import org.fusesource.meshkeeper.util.internal.MeshKeeperWrapper;

public class MeshKeeperFactory {
    public static final String MESHKEEPER_REGISTRY_PROPERTY = "meshkeeper.registry.uri";
    public static final String MESHKEEPER_PROVISIONER_PROPERTY = "meshkeeper.provisioner.uri";
    public static final String MESHKEEPER_BASE_PROPERTY = "meshkeeper.base";
    public static final String MESHKEEPER_UUID_PROPERTY = "meshkeeper.uuid";
    private static final ProvisioningTracker PROVISIONING_TRACKER = new ProvisioningTracker();

    public static File getDefaultBaseDirectory() {
        return new File(System.getProperty(MESHKEEPER_BASE_PROPERTY, "./meshkeeper"));
    }

    public static File getDefaultClientDirectory() {
        return new File(MeshKeeperFactory.getDefaultBaseDirectory(), "client");
    }

    public static File getDefaultAgentDirectory() {
        return new File(MeshKeeperFactory.getDefaultBaseDirectory(), "agent");
    }

    public static File getDefaultServerDirectory() {
        return new File(MeshKeeperFactory.getDefaultBaseDirectory(), "server");
    }

    public static final boolean isInMeshContainer() {
        return MeshContainer.isInMeshContainer();
    }

    public static final MeshKeeper getContainerMeshKeeper() {
        return MeshContainer.getMeshKeeper();
    }

    public static MeshKeeper createMeshKeeper() throws Exception {
        String url = System.getProperty(MESHKEEPER_REGISTRY_PROPERTY, "embedded");
        if ("provisioned".equals(url)) {
            url = PROVISIONING_TRACKER.getProvisioner().findMeshRegistryUri();
        } else if ("provision".equals(url) || "embedded".equals(url)) {
            return new MeshKeeperWrapper(MeshKeeperFactory.createMeshKeeper(PROVISIONING_TRACKER.acquireProvisioned())){
                AtomicBoolean destroyed = new AtomicBoolean(false);

                public void destroy() throws Exception {
                    this.next.destroy();
                    if (this.destroyed.compareAndSet(false, true)) {
                        PROVISIONING_TRACKER.releaseProvisioned();
                    }
                }
            };
        }
        return MeshKeeperFactory.createMeshKeeper(url);
    }

    public static MeshKeeper createMeshKeeper(String registry) throws Exception {
        return MeshKeeperFactory.createMeshKeeper(registry, MeshKeeperFactory.getDefaultClientDirectory());
    }

    public static MeshKeeper createMeshKeeper(String registry, File dataDir) throws Exception {
        DistributorFactory df = new DistributorFactory();
        df.setRegistryUri(registry);
        df.setDirectory(dataDir.getCanonicalPath());
        DefaultDistributor mk = df.create();
        mk.start();
        return mk;
    }

    public static LaunchAgent createAgent(MeshKeeper keeper) throws Exception {
        return MeshKeeperFactory.createAgent(keeper, MeshKeeperFactory.getDefaultAgentDirectory());
    }

    public static LaunchAgent createAgent(MeshKeeper keeper, File dataDir) throws Exception {
        LaunchAgent agent = new LaunchAgent();
        agent.setMeshKeeper(keeper);
        if (dataDir == null) {
            dataDir = MeshKeeperFactory.getDefaultAgentDirectory();
        }
        agent.setDirectory(dataDir);
        agent.start();
        return agent;
    }

    public static ControlServer createControlServer(String registry) throws Exception {
        return MeshKeeperFactory.createControlServer(registry, MeshKeeperFactory.getDefaultServerDirectory());
    }

    public static ControlServer createControlServer(String registry, File dataDir) throws Exception {
        ControlServer rc = new ControlServer();
        if (registry != null) {
            rc.setRegistryUri(registry);
        }
        rc.setDirectory(dataDir.getCanonicalPath());
        rc.start();
        return rc;
    }

    private static class ProvisioningTracker {
        private Provisioner provisioner = null;
        private int acquireCounter;

        private ProvisioningTracker() {
        }

        public synchronized String acquireProvisioned() throws Exception {
            if (this.acquireCounter == 0) {
                this.getProvisioner().deploy();
            }
            ++this.acquireCounter;
            return this.getProvisioner().findMeshRegistryUri();
        }

        public synchronized void releaseProvisioned() throws Exception {
            --this.acquireCounter;
            if (this.acquireCounter != 0) {
                return;
            }
            this.getProvisioner().unDeploy(false);
        }

        public synchronized Provisioner getProvisioner() throws Exception {
            if (this.provisioner == null) {
                String provisionerUri = System.getProperty(MeshKeeperFactory.MESHKEEPER_PROVISIONER_PROPERTY, "embedded");
                this.provisioner = (Provisioner)new ProvisionerFactory().create(provisionerUri);
            }
            return this.provisioner;
        }
    }
}

