/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.meshkeeper.classloader;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.fusesource.meshkeeper.classloader.ClassLoaderFactory;
import org.fusesource.meshkeeper.distribution.PluginClassLoader;
import org.fusesource.meshkeeper.util.internal.ClassLoadingAwareObjectInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Marshalled<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ClassLoaderFactory classLoaderFactory;
    private final byte[] serializedObject;

    public Marshalled(ClassLoaderFactory classLoaderFactory, T value) throws IOException {
        this.classLoaderFactory = classLoaderFactory;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream os = new ObjectOutputStream(baos);
        os.writeObject(value);
        os.close();
        this.serializedObject = baos.toByteArray();
    }

    public ClassLoaderFactory getClassLoaderFactory() {
        return this.classLoaderFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(ClassLoader cl) throws IOException, ClassNotFoundException {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(cl);
        try {
            final ClassLoader[] loaders = new ClassLoader[]{cl, PluginClassLoader.getDefaultPluginLoader()};
            ByteArrayInputStream bais = new ByteArrayInputStream(this.serializedObject);
            ClassLoadingAwareObjectInputStream is = new ClassLoadingAwareObjectInputStream(bais){

                protected ClassLoader[] getClassLoaders() {
                    return loaders;
                }
            };
            Object object = is.readObject();
            return (T)object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }
}

