/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.meshkeeper.classloader.basic;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.fusesource.meshkeeper.classloader.ClassLoaderFactory;
import org.fusesource.meshkeeper.classloader.basic.BasicClassLoaderServer;
import org.fusesource.meshkeeper.util.internal.HexSupport;

public class BasicClassLoaderFactory
implements ClassLoaderFactory {
    private static final long serialVersionUID = 3L;
    private static final int CHUNK_SIZE = 65536;
    private static final Log LOG = LogFactory.getLog(BasicClassLoaderFactory.class);
    private BasicClassLoaderServer.IServer server;
    private String registryPath;
    private final long id;

    public BasicClassLoaderFactory(BasicClassLoaderServer.IServer proxy, long id) {
        this.server = proxy;
        this.id = id;
    }

    void setRegistryPath(String registryPath) {
        this.registryPath = registryPath;
    }

    public String getRegistryPath() {
        return this.registryPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLoader createClassLoader(ClassLoader parent, File cacheDir) throws Exception {
        List<BasicClassLoaderServer.PathElement> elements = this.server.getPathElements(this.id);
        if (elements == null) {
            throw new IOException("Unexpected Remote Response");
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        for (BasicClassLoaderServer.PathElement element : elements) {
            if (element.url != null) {
                urls.add(element.url);
                continue;
            }
            cacheDir.mkdirs();
            String name = "";
            if (element.name != null) {
                if (element.name.indexOf(".") > 0) {
                    String suffix = element.name.substring(element.name.lastIndexOf("."));
                    String prefix = element.name.substring(0, element.name.lastIndexOf("."));
                    name = prefix + "_" + HexSupport.toHexFromBytes(element.fingerprint) + suffix;
                } else {
                    name = HexSupport.toHexFromBytes(element.fingerprint) + "_" + element.name;
                }
            } else {
                name = HexSupport.toHexFromBytes(element.fingerprint) + ".jar";
            }
            File file = new File(cacheDir, name);
            if (!file.exists()) {
                LOG.debug((Object)("Downloading: " + file));
                File tmp = null;
                FileOutputStream out = null;
                try {
                    tmp = File.createTempFile(name, ".part", cacheDir);
                    out = new FileOutputStream(tmp);
                    int pos = 0;
                    while (true) {
                        byte[] data = this.server.download(element.id, pos, 65536);
                        out.write(data);
                        if (data.length < 65536) {
                            break;
                        }
                        pos += 65536;
                    }
                }
                finally {
                    try {
                        out.close();
                    }
                    catch (Throwable e) {}
                }
                if (!tmp.renameTo(file)) {
                    tmp.delete();
                }
            }
            if (file.exists()) {
                if (!Arrays.equals(element.fingerprint, BasicClassLoaderFactory.fingerprint(new FileInputStream(file))) || element.length != file.length()) {
                    throw new IOException("fingerprint missmatch: " + name);
                }
                urls.add(file.toURI().toURL());
                continue;
            }
            throw new IOException("Could not download: " + name);
        }
        URL[] t = new URL[urls.size()];
        urls.toArray(t);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Created URL class loader with: " + urls));
        }
        return new URLClassLoader(t, parent){

            @Override
            protected Class<?> findClass(String name) throws ClassNotFoundException {
                try {
                    return super.findClass(name);
                }
                catch (ClassNotFoundException e) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Couldn't find class: " + name));
                    }
                    throw e;
                }
            }

            @Override
            protected Class<?> loadClass(String name, boolean resolveIt) throws ClassNotFoundException {
                Class<?> c = super.loadClass(name, resolveIt);
                if (c != null && LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Loaded class: " + c.getName()));
                }
                return c;
            }
        };
    }

    static byte[] fingerprint(InputStream is) throws IOException {
        try {
            int c;
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] buffer = new byte[4096];
            while ((c = is.read(buffer)) > 0) {
                md.update(buffer, 0, c);
            }
            byte[] byArray = md.digest();
            return byArray;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e.toString());
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ignore) {}
        }
    }
}

