/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.meshkeeper.classloader.basic;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.fusesource.meshkeeper.Distributable;
import org.fusesource.meshkeeper.MeshKeeper;
import org.fusesource.meshkeeper.classloader.ClassLoaderFactory;
import org.fusesource.meshkeeper.classloader.ClassLoaderServer;
import org.fusesource.meshkeeper.classloader.basic.BasicClassLoaderFactory;
import org.fusesource.meshkeeper.util.internal.FileSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicClassLoaderServer
implements ClassLoaderServer {
    private static final Log LOG = LogFactory.getLog(BasicClassLoaderServer.class);
    static final long ROUNDUP_MILLIS = 1999L;
    private final MeshKeeper meshKeeper;
    private final ConcurrentHashMap<ClassLoader, ClassLoaderFactory> factories = new ConcurrentHashMap();
    private static final AtomicLong ids = new AtomicLong();
    private final ConcurrentHashMap<Long, ArrayList<ExportedFile>> exportedClassLoaders = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, ExportedFile> exportedFiles = new ConcurrentHashMap();
    private final Server server = new Server();
    private IServer proxy;

    public BasicClassLoaderServer(MeshKeeper meshKeeper) {
        this.meshKeeper = meshKeeper;
    }

    @Override
    public synchronized void start() throws Exception {
        if (this.proxy == null) {
            this.proxy = this.meshKeeper.remoting().export(this.server, new Class[0]);
        }
    }

    @Override
    public synchronized void stop() throws Exception {
        if (this.proxy != null) {
            for (ClassLoaderFactory exported : this.factories.values()) {
                this.meshKeeper.registry().removeRegistryData(exported.getRegistryPath(), true);
            }
            this.meshKeeper.remoting().unexport(this.proxy);
            this.proxy = null;
        }
    }

    @Override
    public ClassLoaderFactory export(List<File> classPath, String registryPath) throws Exception {
        ArrayList<ExportedFile> exports = new ArrayList<ExportedFile>();
        for (File file : classPath) {
            BasicClassLoaderServer.addExportedFile(exports, file);
        }
        long id = ids.incrementAndGet();
        this.exportedClassLoaders.put(id, exports);
        for (ExportedFile export : exports) {
            this.exportedFiles.put(export.element.id, export);
        }
        BasicClassLoaderFactory factory = new BasicClassLoaderFactory(this.proxy, id);
        factory.setRegistryPath(this.meshKeeper.registry().addRegistryObject(registryPath, true, factory));
        return factory;
    }

    @Override
    public ClassLoaderFactory export(ClassLoader classLoader, String registryPath, int maxExportDepth) throws Exception {
        ClassLoaderFactory factory = this.factories.get(classLoader);
        if (factory == null) {
            ArrayList<ExportedFile> exports = new ArrayList<ExportedFile>();
            BasicClassLoaderServer.addExportedFiles(classLoader, maxExportDepth, exports);
            long id = ids.incrementAndGet();
            this.exportedClassLoaders.put(id, exports);
            for (ExportedFile export : exports) {
                this.exportedFiles.put(export.element.id, export);
            }
            BasicClassLoaderFactory ret = new BasicClassLoaderFactory(this.proxy, id);
            ret.setRegistryPath(this.meshKeeper.registry().addRegistryObject(registryPath, true, ret));
            factory = ret;
            this.factories.put(classLoader, factory);
        }
        return factory;
    }

    private static void addExportedFiles(ClassLoader classLoader, int maxExportDepth, ArrayList<ExportedFile> elements) throws IOException {
        if (maxExportDepth > 0 && classLoader.getParent() != null) {
            BasicClassLoaderServer.addExportedFiles(classLoader.getParent(), maxExportDepth - 1, elements);
        }
        BasicClassLoaderServer.addExportedFiles(classLoader, elements);
    }

    private static void addExportedFiles(ClassLoader classLoader, ArrayList<ExportedFile> elements) throws IOException {
        if (!(classLoader instanceof URLClassLoader)) {
            throw new IOException("Encountered a non URLClassLoader classloader.");
        }
        BasicClassLoaderServer.addExportedURLs(((URLClassLoader)classLoader).getURLs(), elements);
    }

    private static void addExportedURLs(URL[] urls, ArrayList<ExportedFile> elements) throws IOException {
        for (URL url : urls) {
            if ("file".equals(url.getProtocol())) {
                File file;
                try {
                    file = new File(url.toURI());
                }
                catch (URISyntaxException e) {
                    IOException ioe = new IOException(e.getMessage());
                    ioe.initCause(e);
                    throw ioe;
                }
                BasicClassLoaderServer.addExportedFile(elements, file);
                continue;
            }
            ExportedFile exportedFile = new ExportedFile();
            exportedFile.element.id = ids.incrementAndGet();
            exportedFile.element.url = url;
            elements.add(exportedFile);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Exporting: " + url.toString()));
        }
    }

    private static void addExportedFile(ArrayList<ExportedFile> elements, File file) throws IOException {
        ExportedFile exportedFile = new ExportedFile();
        exportedFile.file = file;
        if (!file.exists()) {
            return;
        }
        for (ExportedFile element : elements) {
            if (!file.equals(element.file)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("duplicate file :" + file + " on classpath"));
            }
            return;
        }
        ArrayList<URL> manifestClasspath = null;
        if (file.isDirectory()) {
            if (file.list().length <= 0) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Jaring: " + file));
            }
            File jar = exportedFile.jared = FileSupport.jar(file);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Jared: " + file + " as: " + jar));
            }
            file = jar;
        } else {
            String name = file.getName();
            if (!name.endsWith(".jar") && !name.endsWith(".zip")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Not a jar.. ommititng from the classpath: " + file));
                }
                return;
            }
            try {
                String classpath;
                JarFile jar = new JarFile(file);
                Manifest manifest = jar.getManifest();
                if (manifest != null && (classpath = (String)manifest.getMainAttributes().get(Attributes.Name.CLASS_PATH)) != null) {
                    String[] entries = classpath.split(" ");
                    manifestClasspath = new ArrayList<URL>(entries.length);
                    for (String entry : classpath.split(" ")) {
                        manifestClasspath.add(new URL(file.getParentFile().toURI().toURL(), entry));
                    }
                }
            }
            catch (Exception e) {
                LOG.warn((Object)("Error reading jar manifest for: " + file));
            }
        }
        exportedFile.element.id = ids.incrementAndGet();
        exportedFile.element.length = file.length();
        exportedFile.element.fingerprint = BasicClassLoaderFactory.fingerprint(new FileInputStream(file));
        elements.add(exportedFile);
        if (manifestClasspath != null) {
            BasicClassLoaderServer.addExportedURLs(manifestClasspath.toArray(new URL[0]), elements);
        }
    }

    static class ExportedFile {
        public final PathElement element = new PathElement();
        public File file;
        public File jared;

        ExportedFile() {
        }

        public void setPathElementName() {
            if (this.element.name != null) {
                return;
            }
            if (this.jared != null) {
                this.element.name = this.jared.getName();
            } else if (this.file != null) {
                this.element.name = this.file.getName();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Server
    implements IServer {
        @Override
        public List<PathElement> getPathElements(long classLoaderId) throws Exception {
            LOG.debug((Object)("Client is downloading the classpath list for " + classLoaderId));
            ArrayList files = (ArrayList)BasicClassLoaderServer.this.exportedClassLoaders.get(classLoaderId);
            if (files == null) {
                throw new IllegalArgumentException("Requested class loader not found.");
            }
            ArrayList<PathElement> rc = new ArrayList<PathElement>(files.size());
            for (ExportedFile file : files) {
                file.setPathElementName();
                rc.add(file.element);
            }
            return rc;
        }

        @Override
        public byte[] download(long fileId, int pos, int length) throws IOException {
            ExportedFile exportedFile = (ExportedFile)BasicClassLoaderServer.this.exportedFiles.get(fileId);
            if (exportedFile == null) {
                throw new IllegalArgumentException("Requested file not found: " + fileId);
            }
            File file = exportedFile.jared == null ? exportedFile.file : exportedFile.jared;
            LOG.debug((Object)("Client downloading from: " + file + " starting at " + pos));
            return FileSupport.read(file, pos, length);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IServer
    extends Distributable {
        public List<PathElement> getPathElements(long var1) throws Exception;

        public byte[] download(long var1, int var3, int var4) throws IOException;
    }

    public static class PathElement
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public long id;
        public String name;
        public byte[] fingerprint;
        public long length;
        public URL url;
    }
}

