/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.meshkeeper.control;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.fusesource.meshkeeper.MeshEvent;
import org.fusesource.meshkeeper.MeshEventListener;
import org.fusesource.meshkeeper.MeshKeeper;
import org.fusesource.meshkeeper.MeshKeeperFactory;
import org.fusesource.meshkeeper.control.ControlService;
import org.fusesource.meshkeeper.control.ControlServiceFactory;
import org.fusesource.meshkeeper.distribution.DistributorFactory;
import org.fusesource.meshkeeper.launcher.LaunchAgent;
import org.fusesource.meshkeeper.util.internal.FileSupport;

public class ControlServer {
    public static final String CONTROLLER_PROP_FILE_NAME = "controller.properties";
    Log log = LogFactory.getLog(ControlServer.class);
    private static final ControlServiceFactory SERVICE_FACTORY = new ControlServiceFactory();
    public static final String DEFAULT_JMS_URI = "activemq:tcp://0.0.0.0:0";
    public static final String DEFAULT_REMOTING_URI = "rmiviajms:activemq:tcp://0.0.0.0:0";
    public static final String DEFAULT_REGISTRY_URI = "zk:tcp://0.0.0.0:4040";
    public static final String DEFAULT_EVENT_URI = "eventviajms:activemq:tcp://0.0.0.0:0";
    public static final String REMOTING_URI_PATH = "/meshkeeper/control/remoting-uri";
    public static final String EVENTING_URI_PATH = "/meshkeeper/control/eventing-uri";
    public static final String REPOSITORY_URI_PATH = "/meshkeeper/control/repository-uri";
    ControlService rmiServer;
    ControlService registryServer;
    MeshKeeper meshKeeper;
    private String jmsUri = "activemq:tcp://0.0.0.0:0";
    private String registryUri = "zk:tcp://0.0.0.0:4040";
    private String repositoryUri = System.getProperty("meshkeeper.repository.uri");
    private String directory = MeshKeeperFactory.getDefaultServerDirectory().getPath();
    private Thread shutdownHook;
    private Runnable preShutdownHook;
    private LaunchAgent embeddedAgent;
    private boolean startEmbeddedAgent;
    public static final String CONTROL_TOPIC = "meshkeeper.control";

    public void start() throws Exception {
        this.deleteControllerProps();
        this.shutdownHook = new Thread("MeshKeeper Control Server Shutdown Hook"){

            public void run() {
                ControlServer.this.log.debug((Object)("Executing Shutdown Hook for " + ControlServer.this));
                try {
                    ControlServer.this.destroy();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        this.log.info((Object)("Creating JMS Server at " + this.jmsUri));
        String SLASH = File.separator;
        try {
            this.rmiServer = (ControlService)SERVICE_FACTORY.create(this.jmsUri);
            this.rmiServer.setDirectory(this.directory + SLASH + "jms");
            this.rmiServer.start();
            this.log.info((Object)("JMS Server started: " + this.rmiServer.getName()));
        }
        catch (Exception e) {
            this.log.error((Object)e);
            this.destroy();
            throw new Exception("Error starting JMS Server", e);
        }
        this.log.info((Object)("Creating Registry Server at " + this.registryUri));
        try {
            this.registryServer = (ControlService)SERVICE_FACTORY.create(this.registryUri);
            this.registryServer.setDirectory(this.directory + SLASH + "registry");
            this.registryServer.start();
            this.log.info((Object)("Registry Server started: " + this.registryServer.getName() + " uri: " + this.registryServer.getServiceUri()));
        }
        catch (Exception e) {
            this.log.error((Object)"Error starting regisry server", (Throwable)e);
            this.destroy();
            throw new Exception("Error starting Registry Server", e);
        }
        try {
            this.log.info((Object)("Connecting to registry server at " + this.registryServer.getServiceUri()));
            String eventingUri = "eventviajms:" + this.rmiServer.getServiceUri();
            String remotingUri = "rmiviajms:" + this.rmiServer.getServiceUri();
            DistributorFactory factory = new DistributorFactory();
            factory.setRegistryUri(this.registryServer.getServiceUri());
            factory.setEventingUri(eventingUri);
            factory.setRemotingUri(remotingUri);
            factory.setDirectory(this.getDirectory());
            this.meshKeeper = factory.create();
            this.meshKeeper.registry().removeRegistryData(REMOTING_URI_PATH, true);
            this.meshKeeper.registry().addRegistryObject(REMOTING_URI_PATH, false, (Serializable)((Object)remotingUri));
            this.log.info((Object)("Registered RMI control server at /meshkeeper/control/remoting-uri=" + remotingUri));
            this.meshKeeper.registry().removeRegistryData(EVENTING_URI_PATH, true);
            this.meshKeeper.registry().addRegistryObject(EVENTING_URI_PATH, false, (Serializable)((Object)eventingUri));
            this.log.info((Object)("Registered event server at /meshkeeper/control/eventing-uri=" + eventingUri));
            this.meshKeeper.registry().removeRegistryData(REPOSITORY_URI_PATH, true);
            if (this.repositoryUri != null) {
                this.meshKeeper.registry().addRegistryObject(REPOSITORY_URI_PATH, false, (Serializable)((Object)this.repositoryUri));
                this.log.info((Object)("Registered repository uri at /meshkeeper/control/repository-uri=" + this.repositoryUri));
            } else {
                this.log.info((Object)"Common repository uri was not set, some repository services may not be available");
            }
            this.saveControllerProps();
            this.meshKeeper.eventing().openEventListener(new MeshEventListener(){

                public void onEvent(MeshEvent e) {
                    switch (ControlEvent.getControlEvent(e)) {
                        case SHUTDOWN: {
                            ControlServer.this.log.info((Object)("Got shutdown request: " + e));
                            new Thread("Controller Shutdown"){

                                public void run() {
                                    try {
                                        ControlServer.this.destroy();
                                    }
                                    catch (Exception e) {
                                        ControlServer.this.log.warn((Object)"Error during control server shutdown", (Throwable)e);
                                    }
                                }
                            }.start();
                            break;
                        }
                        default: {
                            ControlServer.this.log.warn((Object)("Got unknown control event: " + e));
                        }
                    }
                }
            }, CONTROL_TOPIC);
            if (this.startEmbeddedAgent && this.embeddedAgent == null) {
                this.embeddedAgent = new LaunchAgent();
            }
            if (this.embeddedAgent != null) {
                this.embeddedAgent.setMeshKeeper(this.meshKeeper);
                this.embeddedAgent.setDirectory(new File(this.getDirectory()));
                this.embeddedAgent.start();
            }
            this.log.info((Object)("MeshKeeper Successfully started. The Registry Service is listening on: " + this.getRegistryUri()));
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
            this.destroy();
            throw new Exception("Error registering control server", e);
        }
    }

    public void setEmbeddedLaunchAgent(LaunchAgent embeddedAgent) {
        this.embeddedAgent = embeddedAgent;
    }

    public LaunchAgent getEmbeddedLaunchAgent() {
        return this.embeddedAgent;
    }

    public void setPreShutdownHook(Runnable runnable) {
        this.preShutdownHook = runnable;
    }

    private final void deleteControllerProps() {
        FileSupport.recursiveDelete(new File(this.getDirectory(), CONTROLLER_PROP_FILE_NAME));
    }

    private final void saveControllerProps() throws IOException {
        Properties props = new Properties();
        props.put("meshkeeper.registry.uri", this.registryServer.getServiceUri());
        String provisionerId = System.getProperty("meshkeeper.provisionerId");
        if (provisionerId != null) {
            this.log.info((Object)("Writing provisioner id: " + provisionerId));
            props.put("meshkeeper.provisionerId", provisionerId);
        } else {
            props.put("meshkeeper.provisionerId", "none");
        }
        File f = new File(this.getDirectory(), CONTROLLER_PROP_FILE_NAME);
        if (f.exists()) {
            f.delete();
        }
        f.getParentFile().mkdirs();
        f.deleteOnExit();
        PrintStream fout = new PrintStream(f);
        props.store(fout, null);
        fout.flush();
        fout.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws Exception {
        if (Thread.currentThread() != this.shutdownHook) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
        }
        this.deleteControllerProps();
        if (this.preShutdownHook != null) {
            this.preShutdownHook.run();
            this.preShutdownHook = null;
        }
        Exception first = null;
        if (this.embeddedAgent != null) {
            try {
                this.embeddedAgent.stop();
            }
            catch (Exception e) {
                Exception exception = first = first == null ? e : first;
            }
        }
        if (this.meshKeeper != null) {
            try {
                this.meshKeeper.destroy();
            }
            catch (Exception e) {
                first = first == null ? e : first;
            }
            finally {
                this.meshKeeper = null;
            }
        }
        this.log.info((Object)"Shutting down registry server");
        if (this.registryServer != null) {
            try {
                this.registryServer.destroy();
            }
            catch (Exception e) {
                first = first == null ? e : first;
            }
            finally {
                this.registryServer = null;
            }
        }
        this.log.info((Object)"Shutting down rmi server");
        if (this.rmiServer != null) {
            try {
                this.rmiServer.destroy();
            }
            catch (Exception e) {
                first = first == null ? e : first;
            }
            finally {
                this.rmiServer = null;
            }
        }
        ControlServer controlServer = this;
        synchronized (controlServer) {
            this.notifyAll();
        }
        if (first != null) {
            throw first;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join() throws InterruptedException {
        ControlServer controlServer = this;
        synchronized (controlServer) {
            this.wait();
        }
    }

    public void setRepositoryUri(String repositoryUri) {
        this.repositoryUri = repositoryUri == null || repositoryUri.trim().length() == 0 ? null : repositoryUri;
    }

    public String getRepositoryUri() {
        return this.repositoryUri;
    }

    public String getJmsUri() {
        return this.jmsUri;
    }

    public void setJmsUri(String jmsProvider) {
        this.jmsUri = jmsProvider;
    }

    public String getRegistryUri() {
        if (this.registryServer != null) {
            return this.registryServer.getServiceUri();
        }
        return this.registryUri;
    }

    public void setStartEmbeddedAgent(boolean startEmbeddedAgent) {
        this.startEmbeddedAgent = startEmbeddedAgent;
    }

    public boolean getStartEmbeddedAgent() {
        return this.startEmbeddedAgent;
    }

    public String getRegistryConnectUri() {
        if (this.registryServer != null) {
            return this.registryServer.getServiceUri();
        }
        return this.registryUri;
    }

    public void setRegistryUri(String registryProvider) {
        this.registryUri = registryProvider;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public String getDirectory() {
        return this.directory;
    }

    public MeshKeeper getMeshKeeper() {
        return this.meshKeeper;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ControlEvent {
        SHUTDOWN;


        public MeshEvent createEvent(String source, Object attachment) {
            return new MeshEvent(this.ordinal(), source, attachment);
        }

        public static ControlEvent getControlEvent(MeshEvent e) {
            if (e == null) {
                return null;
            }
            try {
                return ControlEvent.values()[e.getType()];
            }
            catch (Throwable thrown) {
                return null;
            }
        }
    }
}

