/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.meshkeeper.control;

import java.util.Arrays;
import java.util.LinkedList;
import org.fusesource.meshkeeper.MeshKeeperFactory;
import org.fusesource.meshkeeper.control.ControlServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main {
    private static final void showUsage() {
        System.out.println("Usage:");
        System.out.println("Args:");
        System.out.println("  -h, --help                  -- this message");
        System.out.println("  [--jms <uri>]               -- specifies listening address for jms.");
        System.out.println("  [--registry <uri>]          -- specifies listening address for the regsitry.");
        System.out.println("  [--directory <directory>]   -- specifies data directory used by control server.");
        System.out.println("  [--repository <uri>]        -- specifies a uri to a centralized repository.");
    }

    public static void main(String[] args) {
        String jv = System.getProperty("java.version").substring(0, 3);
        if (jv.compareTo("1.5") < 0) {
            System.err.println("The Control Server requires jdk 1.5 or higher to run, the current java version is " + System.getProperty("java.version"));
            System.exit(-1);
            return;
        }
        if (System.getProperty("meshkeeper.application") == null) {
            System.setProperty("meshkeeper.application", Main.class.getName());
        }
        String jms = "activemq:tcp://0.0.0.0:0";
        String registry = "zk:tcp://0.0.0.0:4040";
        String repository = null;
        String directory = MeshKeeperFactory.getDefaultServerDirectory().getPath();
        LinkedList<String> alist = new LinkedList<String>(Arrays.asList(args));
        try {
            while (!alist.isEmpty()) {
                String arg = alist.removeFirst();
                if (arg.equals("--help") || arg.equals("-h")) {
                    Main.showUsage();
                    return;
                }
                if (arg.equals("--jms")) {
                    Main.assertHasAdditionalArg(alist, "Expected uri after --jms");
                    jms = alist.removeFirst();
                    continue;
                }
                if (arg.equals("--directory")) {
                    Main.assertHasAdditionalArg(alist, "Directory expected after --directory");
                    directory = alist.removeFirst();
                    continue;
                }
                if (arg.equals("--registry")) {
                    String message = "Expected uri after --registry";
                    Main.assertHasAdditionalArg(alist, message);
                    registry = alist.removeFirst();
                    continue;
                }
                if (arg.equals("--repository")) {
                    Main.assertHasAdditionalArg(alist, "Expected url after --repository");
                    repository = alist.removeFirst();
                    continue;
                }
                if (arg.equals("--provisionerId")) {
                    Main.assertHasAdditionalArg(alist, "Expected provisionerId after --provisionerId");
                    System.setProperty("meshkeeper.provisionerId", alist.removeFirst());
                    continue;
                }
                throw new UsageException("Unexpected argument: " + arg);
            }
        }
        catch (UsageException e) {
            System.out.println("Invalid usage: " + e.getMessage());
            System.out.println();
            Main.showUsage();
            System.exit(-1);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-2);
        }
        try {
            ControlServer server = new ControlServer();
            server.setDirectory(directory);
            server.setJmsUri(jms);
            server.setRepositoryUri(repository);
            server.setRegistryUri(registry);
            server.start();
            server.join();
            System.out.println("Control Server Exited");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-3);
        }
        System.exit(0);
    }

    private static void assertHasAdditionalArg(LinkedList<String> alist, String message) throws Exception {
        if (alist.isEmpty()) {
            throw new UsageException(message);
        }
    }

    static class UsageException
    extends Exception {
        UsageException(String message) {
            super(message);
        }
    }
}

