/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.meshkeeper.distribution;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.fusesource.meshkeeper.distribution.FactoryFinder;
import org.fusesource.meshkeeper.distribution.PluginClassLoader;
import org.fusesource.meshkeeper.util.internal.IntrospectionSupport;
import org.fusesource.meshkeeper.util.internal.URISupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPluginFactory<P> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final P create(String uri) throws Exception {
        URI providerUri = new URI(uri);
        String factoryName = providerUri.getScheme();
        String remaining = providerUri.getSchemeSpecificPart();
        if (factoryName == null) {
            factoryName = remaining;
            remaining = "";
        }
        AbstractPluginFactory f = (AbstractPluginFactory)this.getFactoryFinder().create(factoryName);
        ClassLoader orig = Thread.currentThread().getContextClassLoader();
        PluginClassLoader pcl = PluginClassLoader.getContextPluginLoader();
        Thread.currentThread().setContextClassLoader(pcl);
        try {
            P p = f.createPlugin(remaining);
            return p;
        }
        finally {
            Thread.currentThread().setContextClassLoader(orig);
        }
    }

    protected abstract FactoryFinder getFactoryFinder();

    protected P createPlugin(String uri) throws Exception {
        throw new UnsupportedOperationException("Factory class must override createPlugin to return the plugin");
    }

    protected static URI applyQueryParameters(Object target, URI connectUri) throws URISyntaxException {
        Map<String, String> props = URISupport.parseParamters(connectUri);
        if (!props.isEmpty()) {
            IntrospectionSupport.setProperties(target, props);
            connectUri = URISupport.removeQuery(connectUri);
            connectUri = URISupport.createRemainingURI(connectUri, props);
        }
        return connectUri;
    }
}

