/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.meshkeeper.distribution;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.fusesource.meshkeeper.MeshKeeper;
import org.fusesource.meshkeeper.RegistryWatcher;
import org.fusesource.meshkeeper.distribution.AbstractPluginFactory;
import org.fusesource.meshkeeper.distribution.DistributorFactory;
import org.fusesource.meshkeeper.distribution.LaunchClient;
import org.fusesource.meshkeeper.distribution.PluginClassLoader;
import org.fusesource.meshkeeper.distribution.PluginClient;
import org.fusesource.meshkeeper.distribution.event.EventClient;
import org.fusesource.meshkeeper.distribution.event.EventClientFactory;
import org.fusesource.meshkeeper.distribution.registry.RegistryClient;
import org.fusesource.meshkeeper.distribution.registry.RegistryFactory;
import org.fusesource.meshkeeper.distribution.remoting.RemotingClient;
import org.fusesource.meshkeeper.distribution.remoting.RemotingFactory;
import org.fusesource.meshkeeper.distribution.repository.RepositoryClient;
import org.fusesource.meshkeeper.distribution.repository.RepositoryManagerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultDistributor
implements MeshKeeper {
    private Log log = LogFactory.getLog(this.getClass());
    private String registryUri;
    private String remotingUri;
    private String eventingUri;
    private String repositoryUri;
    private String workingDirectory;
    private RemotingWrapper remoting;
    private RegistryClient registry;
    private EventClient eventing;
    private RepositoryClient repository;
    private LaunchClient launchClient;
    private ClassLoader userClassLoader;
    private UserFirstClassLoader pluginUserClassLoader;
    private boolean uuidCreator = true;
    private String uuid;
    private final HashMap<Object, DistributionRef<?>> distributed = new HashMap();
    private AtomicBoolean started = new AtomicBoolean(false);
    private AtomicBoolean destroyed = new AtomicBoolean(false);
    private static final String[] SYSTEM_ROOTS = new String[]{"/meshkeeper", "/zookeeper"};

    DefaultDistributor() {
        this.uuid = System.getProperty("meshkeeper.uuid");
    }

    @Override
    public ScheduledExecutorService getExecutorService() {
        return DistributorFactory.getExecutorService();
    }

    @Override
    public void setUserClassLoader(ClassLoader classLoader) {
        if (this.userClassLoader != classLoader) {
            this.userClassLoader = classLoader;
            this.pluginUserClassLoader = this.userClassLoader == null ? null : new UserFirstClassLoader(this.userClassLoader);
            if (this.registry != null) {
                this.registry.setUserClassLoader(this.pluginUserClassLoader);
            }
            if (this.remoting != null) {
                this.remoting.setUserClassLoader(this.pluginUserClassLoader);
            }
            if (this.eventing != null) {
                this.eventing.setUserClassLoader(this.pluginUserClassLoader);
            }
            if (this.launchClient != null) {
                this.launchClient.setUserClassLoader(this.pluginUserClassLoader);
            }
        }
    }

    @Override
    public ClassLoader getUserClassLoader() {
        return this.userClassLoader;
    }

    @Override
    public String getRegistryConnectUri() {
        return this.registryUri;
    }

    private synchronized <T extends PluginClient> T createPluginClient(String uri, AbstractPluginFactory<T> factory, String lookupPath, String defaultUri) throws PluginCreationException {
        if (this.destroyed.get()) {
            throw new IllegalStateException("destroyed");
        }
        try {
            if (uri == null) {
                if (lookupPath != null) {
                    uri = (String)this.registry().getRegistryObject(lookupPath);
                }
                if (uri == null) {
                    uri = defaultUri;
                }
            }
            PluginClient ret = (PluginClient)factory.create(uri);
            ret.setMeshKeeper(this);
            if (this.userClassLoader != null) {
                ret.setUserClassLoader(this.pluginUserClassLoader);
            }
            ret.start();
            return (T)ret;
        }
        catch (Exception e) {
            PluginCreationException re = new PluginCreationException("Unable to create plugin client from " + factory.getClass().getSimpleName(), e);
            this.log.error((Object)re.getMessage(), (Throwable)re);
            throw re;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized MeshKeeper.Registry registry() throws PluginCreationException {
        if (this.registry == null) {
            DefaultDistributor defaultDistributor = this;
            synchronized (defaultDistributor) {
                if (this.registry == null) {
                    this.registry = new RegistryWrapper(this.createPluginClient(this.registryUri, new RegistryFactory(), null, "zk:tcp://0.0.0.0:4040"));
                }
            }
        }
        return this.registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MeshKeeper.Eventing eventing() throws PluginCreationException {
        if (this.eventing == null) {
            DefaultDistributor defaultDistributor = this;
            synchronized (defaultDistributor) {
                if (this.eventing == null) {
                    this.eventing = this.createPluginClient(this.eventingUri, new EventClientFactory(), "/meshkeeper/control/eventing-uri", "eventviajms:activemq:tcp://0.0.0.0:0");
                }
            }
        }
        return this.eventing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MeshKeeper.Remoting remoting() throws PluginCreationException {
        if (this.remoting == null) {
            DefaultDistributor defaultDistributor = this;
            synchronized (defaultDistributor) {
                if (this.remoting == null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"Creating Remoting Client");
                    }
                    this.remoting = new RemotingWrapper(this.createPluginClient(this.remotingUri, new RemotingFactory(), "/meshkeeper/control/remoting-uri", "rmiviajms:activemq:tcp://0.0.0.0:0"));
                }
            }
        }
        return this.remoting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MeshKeeper.Repository repository() {
        if (this.repository == null) {
            if (this.destroyed.get()) {
                throw new IllegalStateException("destroyed");
            }
            DefaultDistributor defaultDistributor = this;
            synchronized (defaultDistributor) {
                try {
                    RepositoryClient resourceManager = (RepositoryClient)new RepositoryManagerFactory().create(this.repositoryUri);
                    String commonRepoUrl = (String)this.registry.getRegistryObject("/meshkeeper/control/repository-uri");
                    if (commonRepoUrl != null) {
                        resourceManager.setCentralRepoUri(commonRepoUrl, null);
                    }
                    resourceManager.setLocalRepoDir(this.workingDirectory + File.separator + "local-repo");
                    resourceManager.start();
                    this.repository = resourceManager;
                }
                catch (Exception e) {
                    RuntimeException re = new RuntimeException("Error creating repository client", e);
                    this.log.error((Object)re);
                    throw re;
                }
            }
        }
        return this.repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MeshKeeper.Launcher launcher() {
        if (this.launchClient == null) {
            if (this.destroyed.get()) {
                throw new IllegalStateException("destroyed");
            }
            DefaultDistributor defaultDistributor = this;
            synchronized (defaultDistributor) {
                if (this.launchClient == null) {
                    this.launchClient = new LaunchClient();
                    this.launchClient.setMeshKeeper(this);
                    try {
                        this.launchClient.start();
                    }
                    catch (Exception e) {
                        this.log.warn((Object)"Error starting launch client", (Throwable)e);
                        throw new PluginCreationException("Error starting launch client", e);
                    }
                    if (this.userClassLoader != null) {
                        this.launchClient.setUserClassLoader(this.pluginUserClassLoader);
                    }
                }
            }
        }
        return this.launchClient;
    }

    @Override
    public synchronized void start() throws Exception {
        if (this.destroyed.get()) {
            throw new IllegalStateException("Can't start destoyed MeshKeeper");
        }
        this.setUserClassLoader(this.getClass().getClassLoader());
        try {
            this.registry();
            this.remoting();
            this.eventing();
        }
        catch (PluginCreationException re) {
            if (re.getCause() != null && re.getCause() instanceof Exception) {
                throw (Exception)re.getCause();
            }
            throw re;
        }
        this.started.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void destroy() throws Exception {
        if (this.destroyed.compareAndSet(false, true)) {
            this.log.debug((Object)"Shutting down");
            Exception first = null;
            if (this.launchClient != null) {
                try {
                    this.launchClient.destroy();
                }
                catch (Exception e) {
                    first = first == null ? e : first;
                }
                finally {
                    this.launchClient = null;
                }
            }
            if (this.eventing != null) {
                try {
                    this.eventing.destroy();
                }
                catch (Exception e) {
                    first = first == null ? e : first;
                }
                finally {
                    this.eventing = null;
                }
            }
            for (DistributionRef<?> ref : this.distributed.values()) {
                ((DistributionRef)ref).unregister();
            }
            if (this.remoting != null) {
                try {
                    this.remoting.destroy();
                }
                catch (Exception e) {
                    first = first == null ? e : first;
                }
                finally {
                    this.remoting = null;
                }
            }
            if (this.registry != null) {
                if (this.uuidCreator) {
                    try {
                        this.registry().removeRegistryData("/" + this.uuid, true);
                    }
                    catch (Exception e) {
                        first = first == null ? e : first;
                    }
                }
                try {
                    this.registry.destroy();
                }
                catch (Exception e) {
                    first = first == null ? e : first;
                }
                finally {
                    this.registry = null;
                }
            }
            if (this.repository != null) {
                try {
                    this.repository.destroy();
                }
                catch (Exception e) {
                    first = first == null ? e : first;
                }
                finally {
                    this.repository = null;
                }
            }
            if (first != null) {
                throw first;
            }
            this.log.debug((Object)"Shut down");
        }
    }

    public String toString() {
        return "Distributor [exporter: " + this.remoting + " registry: " + this.registry + "]";
    }

    void setRegistryUri(String registryUri) {
        this.registryUri = registryUri;
    }

    void setRemotingUri(String remotingUri) {
        this.remotingUri = remotingUri;
    }

    public void setEventingUri(String eventingUri) {
        this.eventingUri = eventingUri;
    }

    public void setRepositoryUri(String repositoryUri) {
        this.repositoryUri = repositoryUri;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public String getRegistryUri() {
        return this.registryUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T, S extends T> DistributionRef<T> getRef(S object, boolean create, Class<?> ... serviceInterfaces) {
        DistributionRef<Object> ref = null;
        HashMap<Object, DistributionRef<?>> hashMap = this.distributed;
        synchronized (hashMap) {
            ref = this.distributed.get(object);
            if (ref == null && create) {
                ref = new DistributionRef<S>(object, serviceInterfaces);
                this.distributed.put(object, ref);
            }
        }
        return ref;
    }

    public final <T, S extends T> DistributionRef<T> distribute(String path, boolean sequential, S object, Class<?> ... serviceInterfaces) throws Exception {
        DistributionRef<T> ref = this.getRef(object, true, serviceInterfaces);
        ((DistributionRef)ref).register(path, sequential);
        return ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void undistribute(Object object) throws Exception {
        DistributionRef ref = this.getRef(object, false, new Class[0]);
        if (ref != null) {
            ref.unregister();
            HashMap<Object, DistributionRef<?>> hashMap = this.distributed;
            synchronized (hashMap) {
                this.distributed.remove(object);
            }
        }
    }

    @Override
    public String getUUID() {
        return this.setUUID("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String setUUID(String prefix) {
        if (this.uuid == null) {
            DefaultDistributor defaultDistributor = this;
            synchronized (defaultDistributor) {
                if (this.uuid != null) {
                    return this.uuid;
                }
                this.uuidCreator = true;
                if (prefix == null) {
                    prefix = "";
                }
                try {
                    String id = this.registry().addRegistryData("/meshkeeper/UUID/" + prefix, true, null);
                    this.uuid = id.substring(1 + id.lastIndexOf("/"));
                }
                catch (Exception e) {
                    throw new RuntimeException("UUID creation error", e);
                }
            }
        }
        return this.uuid;
    }

    private final MeshKeeper.Remoting remotingDelegate() {
        this.remoting();
        return this.remoting.delegate();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RegistryWrapper
    implements RegistryClient {
        final RegistryClient client;

        RegistryWrapper(RegistryClient client) {
            this.client = client;
        }

        @Override
        public final String addRegistryData(String path, boolean sequential, byte[] data) throws Exception {
            path = this.doPathSubstitutions(path);
            return this.client.addRegistryData(path, sequential, data);
        }

        @Override
        public final String addRegistryObject(String path, boolean sequential, Serializable o) throws Exception {
            path = this.doPathSubstitutions(path);
            return this.client.addRegistryObject(path, sequential, o);
        }

        @Override
        public final void addRegistryWatcher(String path, RegistryWatcher watcher) throws Exception {
            path = this.doPathSubstitutions(path);
            this.client.addRegistryWatcher(path, watcher);
        }

        @Override
        public final void destroy() throws Exception {
            this.client.destroy();
        }

        @Override
        public final MeshKeeper getMeshKeeper() {
            return this.client.getMeshKeeper();
        }

        @Override
        public final byte[] getRegistryData(String path) throws Exception {
            path = this.doPathSubstitutions(path);
            return this.client.getRegistryData(path);
        }

        @Override
        public final <T> T getRegistryObject(String path) throws Exception {
            path = this.doPathSubstitutions(path);
            return this.client.getRegistryObject(path);
        }

        @Override
        public final ClassLoader getUserClassLoader() {
            return this.client.getUserClassLoader();
        }

        @Override
        public final Collection<String> list(String path, boolean recursive, String ... filters) throws Exception {
            if (path.equals("*")) {
                path = "/";
                filters = null;
                return this.client.list(path, recursive, new String[0]);
            }
            if ((path = this.doPathSubstitutions(path)).equals("/")) {
                if (filters == null) {
                    filters = SYSTEM_ROOTS;
                } else {
                    ArrayList<String> filterList = new ArrayList<String>(SYSTEM_ROOTS.length + filters.length);
                    filterList.addAll(Arrays.asList(SYSTEM_ROOTS));
                    filterList.addAll(Arrays.asList(filters));
                    filters = filterList.toArray(new String[0]);
                }
            }
            return this.client.list(path, recursive, filters);
        }

        @Override
        public final void removeRegistryData(String path, boolean recursive) throws Exception {
            path = this.doPathSubstitutions(path);
            this.client.removeRegistryData(path, recursive);
        }

        @Override
        public final void removeRegistryWatcher(String path, RegistryWatcher watcher) throws Exception {
            path = this.doPathSubstitutions(path);
            this.client.removeRegistryWatcher(path, watcher);
        }

        @Override
        public final void setMeshKeeper(MeshKeeper meshKeeper) {
            this.client.setMeshKeeper(meshKeeper);
        }

        @Override
        public final void setUserClassLoader(ClassLoader classLoader) {
            this.client.setUserClassLoader(classLoader);
        }

        @Override
        public final void start() throws Exception {
            this.client.start();
        }

        @Override
        public final <T> T waitForRegistration(String path, long timeout) throws TimeoutException, Exception {
            path = this.doPathSubstitutions(path);
            return this.client.waitForRegistration(path, timeout);
        }

        @Override
        public final <T> Collection<T> waitForRegistrations(String path, int min, long timeout) throws TimeoutException, Exception {
            path = this.doPathSubstitutions(path);
            return this.client.waitForRegistrations(path, min, timeout);
        }

        private final String doPathSubstitutions(String path) {
            if (path == null) {
                path = "";
            }
            if (!path.startsWith("/")) {
                path = "/" + DefaultDistributor.this.getUUID() + "/" + path;
            }
            return path;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UserFirstClassLoader
    extends ClassLoader {
        ArrayList<ClassLoader> delegates = new ArrayList(2);
        ArrayList<String> exceptions = new ArrayList();

        UserFirstClassLoader(ClassLoader userLoader) {
            super(userLoader.getParent());
            this.exceptions.add("net.sf.cglib");
            this.delegates.add(userLoader);
            this.delegates.add(PluginClassLoader.getDefaultPluginLoader());
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            for (String e : this.exceptions) {
                if (!name.startsWith(e)) continue;
                return PluginClassLoader.getDefaultPluginLoader().loadClass(name);
            }
            return super.loadClass(name);
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            try {
                return super.findClass(name);
            }
            catch (ClassNotFoundException cnfe) {
                for (ClassLoader delegate : this.delegates) {
                    try {
                        return delegate.loadClass(name);
                    }
                    catch (ClassNotFoundException cnfe2) {
                    }
                }
                throw new ClassNotFoundException(name);
            }
        }

        @Override
        protected URL findResource(String name) {
            URL url = super.findResource(name);
            for (ClassLoader delegate : this.delegates) {
                if (url != null) break;
                url = delegate.getResource(name);
            }
            return url;
        }

        @Override
        protected Enumeration<URL> findResources(String name) throws IOException {
            Enumeration<URL> urls = null;
            try {
                urls = super.findResources(name);
            }
            catch (IOException ioe) {
                // empty catch block
            }
            for (ClassLoader delegate : this.delegates) {
                if (urls != null) break;
                try {
                    urls = delegate.getResources(name);
                }
                catch (IOException ioe) {}
            }
            return urls;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DistributionRef<D>
    implements MeshKeeper.DistributionRef<D> {
        private D object;
        private D stub;
        private String path;
        private String multiCastPrefix;
        private Class<?>[] serviceInterfaces;

        DistributionRef(D object, Class<?> ... serviceInterfaces) {
            this.object = object;
            this.serviceInterfaces = serviceInterfaces;
        }

        public void setMultiCastPrefix(String multiCastPrefix) {
            this.multiCastPrefix = multiCastPrefix;
        }

        @Override
        public D getProxy() {
            return this.stub;
        }

        @Override
        public D getTarget() {
            return this.object;
        }

        @Override
        public String getRegistryPath() {
            return this.path;
        }

        private synchronized D export() throws Exception {
            if (this.stub == null) {
                this.stub = this.multiCastPrefix != null ? DefaultDistributor.this.remotingDelegate().exportMulticast(this.object, this.multiCastPrefix, this.serviceInterfaces) : DefaultDistributor.this.remotingDelegate().export(this.object, this.serviceInterfaces);
                if (DefaultDistributor.this.log.isDebugEnabled()) {
                    DefaultDistributor.this.log.debug((Object)("Exported: " + this.object + " to " + this.stub));
                }
            }
            return this.stub;
        }

        private synchronized String register(String path, boolean sequential) throws Exception {
            if (this.path == null) {
                if (this.stub == null) {
                    this.export();
                }
                this.path = DefaultDistributor.this.registry().addRegistryObject(path, sequential, (Serializable)this.stub);
            }
            return this.path;
        }

        private synchronized void unexport() throws Exception {
            if (this.stub != null) {
                DefaultDistributor.this.remotingDelegate().unexport(this.stub);
                this.stub = null;
            }
            if (this.path != null) {
                DefaultDistributor.this.registry.removeRegistryData(this.path, true);
            }
        }

        private synchronized void unregister() throws Exception {
            this.unexport();
        }
    }

    public static class PluginCreationException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public PluginCreationException(String string, Exception e) {
            super(string, e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class RemotingWrapper
    implements RemotingClient {
        private final RemotingClient delegate;

        RemotingWrapper(RemotingClient delegate) {
            this.delegate = delegate;
        }

        @Override
        public void setMeshKeeper(MeshKeeper meshKeeper) {
            this.delegate.setMeshKeeper(meshKeeper);
        }

        @Override
        public MeshKeeper getMeshKeeper() {
            return this.delegate.getMeshKeeper();
        }

        @Override
        public final <T> T export(T object, Class<?> ... serviceInterfaces) throws Exception {
            DistributionRef ref = DefaultDistributor.this.getRef(object, true, serviceInterfaces);
            ref.export();
            return (T)ref.stub;
        }

        @Override
        public <T> T exportMulticast(T obj, String address, Class<?> ... interfaces) throws Exception {
            DistributionRef ref = DefaultDistributor.this.getRef(obj, true, interfaces);
            ref.setMultiCastPrefix(address);
            ref.export();
            return (T)ref.stub;
        }

        @Override
        public <T> T getMulticastProxy(String address, Class<?> mainInterface, Class<?> ... extraInterfaces) throws Exception {
            return this.delegate.getMulticastProxy(address, mainInterface, extraInterfaces);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void unexport(Object object) throws Exception {
            DistributionRef ref = DefaultDistributor.this.getRef(object, false, new Class[0]);
            if (ref != null) {
                ref.unregister();
                HashMap hashMap = DefaultDistributor.this.distributed;
                synchronized (hashMap) {
                    DefaultDistributor.this.distributed.remove(object);
                }
            }
        }

        @Override
        public void destroy() throws Exception {
            this.delegate.destroy();
        }

        @Override
        public ClassLoader getUserClassLoader() {
            return this.delegate.getUserClassLoader();
        }

        @Override
        public void setUserClassLoader(ClassLoader classLoader) {
            this.delegate.setUserClassLoader(classLoader);
        }

        @Override
        public void start() throws Exception {
            this.delegate.start();
        }

        public MeshKeeper.Remoting delegate() {
            return this.delegate;
        }

        public String toString() {
            return this.delegate.toString();
        }
    }
}

