/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.meshkeeper.distribution;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.fusesource.meshkeeper.MeshKeeperFactory;
import org.fusesource.meshkeeper.distribution.DefaultDistributor;

public class DistributorFactory {
    private Log log = LogFactory.getLog(DistributorFactory.class);
    private static String DEFAULT_REPOSITORY_PROVIDER = "wagon";
    private static String DEFAULT_REGISTRY_URI = "zk:tcp://0.0.0.0:4040";
    private static final ScheduledExecutorService EXECUTOR;
    private static final AtomicInteger EXECUTOR_COUNT;
    private String repositoryProvider = DEFAULT_REPOSITORY_PROVIDER;
    private String registryUri = DEFAULT_REGISTRY_URI;
    private String directory = MeshKeeperFactory.getDefaultClientDirectory().getPath();
    private String eventingUri;
    private String remotingUri;
    private String repositoryUri;

    public static DefaultDistributor createDefaultDistributor() throws Exception {
        DistributorFactory df = new DistributorFactory();
        return df.create();
    }

    public static void setDefaultRegistryUri(String defaultRegistryUri) {
        DEFAULT_REGISTRY_URI = defaultRegistryUri;
    }

    public static ScheduledExecutorService getExecutorService() {
        return EXECUTOR;
    }

    public DefaultDistributor create() throws Exception {
        DefaultDistributor ret = new DefaultDistributor();
        if (this.registryUri == null) {
            throw new Exception("Registry URI must be set");
        }
        ret.setRegistryUri(this.registryUri);
        ret.setRemotingUri(this.remotingUri);
        ret.setEventingUri(this.eventingUri);
        ret.setRepositoryUri(this.repositoryProvider);
        ret.setWorkingDirectory(this.getDirectory());
        ret.start();
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Created: " + ret));
        }
        return ret;
    }

    public String getRepositoryProvider() {
        return this.repositoryProvider;
    }

    public void setRepositoryProvider(String repositoryProvider) {
        this.repositoryProvider = repositoryProvider;
    }

    public String getRegistryUri() {
        return this.registryUri;
    }

    public void setRegistryUri(String registryUri) {
        this.registryUri = registryUri;
    }

    public String getEventingUri() {
        return this.eventingUri;
    }

    public void setEventingUri(String eventingUri) {
        this.eventingUri = eventingUri;
    }

    public String getRemotingUri() {
        return this.remotingUri;
    }

    public void setRemotingUri(String remotingUri) {
        this.remotingUri = remotingUri;
    }

    public String getRepositoryUri() {
        return this.repositoryUri;
    }

    public void setRepositoryUri(String repositoryUri) {
        this.repositoryUri = repositoryUri;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    static {
        EXECUTOR_COUNT = new AtomicInteger(0);
        EXECUTOR = Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors(), new ThreadFactory(){

            public Thread newThread(Runnable r) {
                return new Thread(r, "MeshKeeperExecutor-" + EXECUTOR_COUNT.incrementAndGet());
            }
        });
    }
}

