/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.meshkeeper.distribution;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import org.fusesource.meshkeeper.distribution.PluginClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FactoryFinder {
    private final String path;
    private final ConcurrentHashMap<String, Class<?>> classMap = new ConcurrentHashMap();

    public FactoryFinder(String path) {
        this.path = path;
    }

    public <T> T create(String key) throws IllegalAccessException, InstantiationException, IOException, ClassNotFoundException {
        Class<T> clazz = this.find(key);
        return clazz.newInstance();
    }

    public <T> Class<T> find(String key) throws ClassNotFoundException, IOException {
        Class<?> clazz = this.classMap.get(key);
        if (clazz == null) {
            clazz = this.loadClass(key);
            this.classMap.put(key, clazz);
        }
        return clazz;
    }

    private Class<?> loadClass(String key) throws ClassNotFoundException, IOException {
        return PluginClassLoader.getContextPluginLoader().loadPlugin(this.path, key);
    }
}

