/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.meshkeeper.distribution;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.fusesource.meshkeeper.Expression;
import org.fusesource.meshkeeper.HostProperties;
import org.fusesource.meshkeeper.JavaLaunch;
import org.fusesource.meshkeeper.LaunchDescription;
import org.fusesource.meshkeeper.MeshContainer;
import org.fusesource.meshkeeper.MeshKeeper;
import org.fusesource.meshkeeper.MeshProcess;
import org.fusesource.meshkeeper.MeshProcessListener;
import org.fusesource.meshkeeper.RegistryWatcher;
import org.fusesource.meshkeeper.classloader.ClassLoaderFactory;
import org.fusesource.meshkeeper.classloader.ClassLoaderServer;
import org.fusesource.meshkeeper.classloader.ClassLoaderServerFactory;
import org.fusesource.meshkeeper.distribution.AbstractPluginClient;
import org.fusesource.meshkeeper.launcher.LaunchAgent;
import org.fusesource.meshkeeper.launcher.LaunchAgentService;
import org.fusesource.meshkeeper.launcher.LaunchClientService;
import org.fusesource.meshkeeper.launcher.MeshContainerService;
import org.fusesource.meshkeeper.util.DefaultProcessListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LaunchClient
extends AbstractPluginClient
implements MeshKeeper.Launcher,
LaunchClientService {
    Log log = LogFactory.getLog(this.getClass());
    RegistryWatcher agentWatcher;
    private long killTimeout = 5000L;
    private long launchTimeout = 60000L;
    private long bindTimeout = 10000L;
    private HashMap<String, LaunchAgentService> knownAgents = new HashMap();
    private HashMap<String, HostProperties> agentProps = new HashMap();
    private HashSet<MeshProcessWatcher> runningProcesses = new HashSet();
    private AtomicBoolean closed = new AtomicBoolean();
    private final HashMap<String, LaunchAgentService> boundAgents = new HashMap();
    private final HashMap<String, HashSet<Integer>> reservedPorts = new HashMap();
    private String name;
    private MeshKeeper.DistributionRef<LaunchClientService> distributionRef;
    private ClassLoaderServer classLoaderServer;
    private ClassLoaderFactory bootStrapClassLoaderFactory;
    private ClassLoader bootStrapClassLoader;
    private int meshContainerCounter;

    LaunchClient() {
    }

    @Override
    public void start() throws Exception {
        this.distributionRef = this.meshKeeper.distribute("/meshkeeper/launchclients/" + System.getProperty("user.name"), true, this, LaunchClientService.class);
        this.name = this.distributionRef.getRegistryPath().substring(this.distributionRef.getRegistryPath().lastIndexOf("/") + 1);
        this.agentWatcher = new RegistryWatcher(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onChildrenChanged(String path, List<String> children) {
                LaunchClient launchClient = LaunchClient.this;
                synchronized (launchClient) {
                    for (String agentId : children) {
                        if (LaunchClient.this.knownAgents.containsKey(agentId)) continue;
                        try {
                            LaunchAgentService pl = (LaunchAgentService)LaunchClient.this.meshKeeper.registry().getRegistryObject(path + "/" + agentId);
                            LaunchClient.this.knownAgents.put(agentId, pl);
                            HostProperties props = pl.getHostProperties();
                            LaunchClient.this.agentProps.put(agentId, props);
                            if (!LaunchClient.this.log.isDebugEnabled()) continue;
                            LaunchClient.this.log.debug((Object)("DISCOVERED: " + props.getAgentId()));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    LaunchClient.this.knownAgents.keySet().retainAll(children);
                    LaunchClient.this.agentProps.keySet().retainAll(children);
                    LaunchClient.this.notifyAll();
                }
            }
        };
        this.meshKeeper.registry().addRegistryWatcher("/meshkeeper/launch-agents", this.agentWatcher);
    }

    @Override
    public synchronized List<Integer> reserveTcpPorts(String agentName, int count) throws Exception {
        agentName = agentName.toUpperCase();
        LaunchAgentService agent = this.getAgent(agentName);
        List<Integer> ports = agent.reserveTcpPorts(count);
        HashSet<Integer> reserved = this.reservedPorts.get(agentName);
        if (reserved == null) {
            reserved = new HashSet();
            this.reservedPorts.put(agentName, reserved);
        }
        reserved.addAll(ports);
        return ports;
    }

    @Override
    public synchronized void releasePorts(String agentName, Collection<Integer> ports) throws Exception {
        HashSet<Integer> reserved = this.reservedPorts.get(agentName = agentName.toUpperCase());
        if (reserved != null) {
            reserved.removeAll(ports);
            if (reserved.isEmpty()) {
                this.reservedPorts.remove(agentName);
            }
        }
        LaunchAgentService agent = this.getAgent(agentName);
        agent.releaseTcpPorts(ports);
    }

    @Override
    public synchronized void releaseAllPorts(String agentName) throws Exception {
        HashSet<Integer> reserved = this.reservedPorts.remove(agentName = agentName.toUpperCase());
        if (reserved != null) {
            this.getAgent(agentName).releaseTcpPorts(reserved);
        }
    }

    @Override
    public synchronized void destroy() throws Exception {
        if (this.classLoaderServer != null) {
            this.classLoaderServer.stop();
        }
        for (String agentName : this.reservedPorts.keySet().toArray(new String[0])) {
            this.releaseAllPorts(agentName);
        }
        try {
            this.releaseAllAgents();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.killRunningProcesses();
        this.meshKeeper.undistribute(this);
        this.meshKeeper.registry().removeRegistryWatcher("/meshkeeper/launch-agents", this.agentWatcher);
        this.meshKeeper.registry().removeRegistryData(this.distributionRef.getRegistryPath(), true);
        this.meshKeeper.registry().removeRegistryData("/meshkeeper/meshcontainers/" + this.name, true);
        this.knownAgents.clear();
        this.agentProps.clear();
        this.closed.set(true);
    }

    @Override
    public void waitForAvailableAgents(long timeout) throws InterruptedException, TimeoutException {
        this.waitForAvailableAgents(1, timeout, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForAvailableAgents(int agentCount, long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        LaunchClient launchClient = this;
        synchronized (launchClient) {
            long start = System.nanoTime();
            for (timeout = unit.toNanos(timeout); timeout > 0L && this.agentProps.isEmpty(); timeout -= System.nanoTime() - start) {
                this.wait(timeout);
                if (this.agentProps.size() < agentCount) continue;
                return;
            }
            if (this.agentProps.isEmpty()) {
                throw new TimeoutException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LaunchAgentService getAgent(String agentName) throws Exception {
        LaunchAgentService pl;
        LaunchAgentService launcher;
        agentName = agentName.toUpperCase();
        LaunchClient launchClient = this;
        synchronized (launchClient) {
            launcher = this.knownAgents.get(agentName);
        }
        if (launcher == null && (pl = (LaunchAgentService)this.meshKeeper.registry().getRegistryObject("/meshkeeper/launch-agents/" + agentName)) != null) {
            HostProperties props = pl.getHostProperties();
            LaunchClient launchClient2 = this;
            synchronized (launchClient2) {
                launcher = this.knownAgents.get(agentName);
                if (launcher == null) {
                    launcher = pl;
                    this.knownAgents.put(agentName, pl);
                    this.agentProps.put(agentName, props);
                }
                this.notifyAll();
            }
        }
        if (launcher == null) {
            throw new Exception("Agent not found:" + agentName);
        }
        return launcher;
    }

    @Override
    public void bindAgent(String agentName) throws Exception {
        this.checkNotClosed();
        agentName = agentName.toUpperCase();
        if (this.boundAgents.containsKey(agentName)) {
            return;
        }
        LaunchAgentService agent = this.getAgent(agentName);
        agent.bind(this.name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HostProperties[] getAvailableAgents() {
        HashMap<String, LaunchAgentService> hashMap = this.knownAgents;
        synchronized (hashMap) {
            return this.agentProps.values().toArray(new HostProperties[this.agentProps.size()]);
        }
    }

    @Override
    public void releaseAgent(String agentName) throws Exception {
        this.checkNotClosed();
        agentName = agentName.toUpperCase();
        LaunchAgentService agent = this.boundAgents.remove(agentName);
        if (agent != null) {
            agent.unbind(this.name);
        }
    }

    @Override
    public void releaseAllAgents() throws Exception {
        this.checkNotClosed();
        ArrayList<String> failed = new ArrayList<String>();
        for (Map.Entry<String, LaunchAgentService> entry : this.boundAgents.entrySet()) {
            try {
                entry.getValue().unbind(this.name);
            }
            catch (Exception ignore) {
                failed.add(entry.getKey());
            }
        }
        if (!failed.isEmpty()) {
            throw new Exception("Failed to release: " + failed);
        }
    }

    private void checkNotClosed() {
        if (this.closed.get()) {
            throw new IllegalStateException("closed");
        }
    }

    @Override
    public MeshProcess launchProcess(String agentId, LaunchDescription launch, MeshProcessListener listener) throws Exception {
        this.checkNotClosed();
        LaunchAgentService agent = this.getAgent(agentId);
        MeshProcessWatcher watcher = new MeshProcessWatcher(listener, agentId);
        this.addWatchedProcess(watcher);
        try {
            watcher.setProcess(agent.launch(launch, this.distributionRef.getRegistryPath(), watcher.getProxy()));
        }
        catch (Exception e) {
            watcher.cleanup();
            throw e;
        }
        return watcher.getProcess();
    }

    @Override
    public LaunchDescription createLaunchDescription() {
        return new LaunchDescription();
    }

    @Override
    public JavaLaunch createJavaLaunch(String mainClass, String ... args) {
        return this.setupJavaLaunch(new JavaLaunch(), mainClass, args);
    }

    @Override
    public JavaLaunch createMeshContainerLaunch() throws Exception {
        MeshContainerLaunch launch = new MeshContainerLaunch();
        launch.regPath = "/meshkeeper/meshcontainers/" + this.name + "/" + ++this.meshContainerCounter;
        this.setupBootstrapJavaLaunch(launch, org.fusesource.meshkeeper.launcher.MeshContainer.class.getName(), launch.regPath);
        return launch;
    }

    @Override
    public JavaLaunch createBootstrapJavaLaunch(String mainClass, String ... args) throws Exception {
        return this.setupBootstrapJavaLaunch(new JavaLaunch(), mainClass, args);
    }

    private JavaLaunch setupJavaLaunch(JavaLaunch launch, String mainClass, String ... args) {
        launch.setMainClass(mainClass);
        launch.addArgs(args);
        for (String propName : LaunchAgent.PROPAGATED_SYSTEM_PROPERTIES) {
            launch.addSystemProperty(Expression.sysProperty(propName, null));
        }
        launch.addSystemProperty(Expression.sysProperty("meshkeeper.registry.uri", Expression.string(this.meshKeeper.getRegistryConnectUri())));
        launch.addSystemProperty("meshkeeper.uuid", this.meshKeeper.getUUID());
        return launch;
    }

    private JavaLaunch setupBootstrapJavaLaunch(JavaLaunch launch, String mainClass, String ... args) {
        launch.setBootstrapClassLoaderFactory(this.getBootstrapClassLoaderFactory().getRegistryPath());
        return this.setupJavaLaunch(launch, mainClass, args);
    }

    @Override
    public MeshContainer launchMeshContainer(String agentId) throws Exception {
        return this.launchMeshContainer(agentId, null, null);
    }

    @Override
    public MeshContainer launchMeshContainer(String agentId, MeshProcessListener listener) throws Exception {
        return this.launchMeshContainer(agentId, null, listener);
    }

    @Override
    public MeshContainer launchMeshContainer(String agentId, JavaLaunch launch, MeshProcessListener listener) throws Exception {
        if (launch == null) {
            launch = this.createMeshContainerLaunch();
        }
        if (!(launch instanceof MeshContainerLaunch)) {
            throw new IllegalStateException("Invalid JavaLaunch, not created via createMeshContainerLaunch");
        }
        String regPath = ((MeshContainerLaunch)launch).regPath;
        MeshProcess proc = this.launchProcess(agentId, launch.toLaunchDescription(), listener);
        try {
            MeshContainerService proxy = (MeshContainerService)this.meshKeeper.registry().waitForRegistration(regPath, this.launchTimeout);
            MeshContainerImpl mc = new MeshContainerImpl(proc, proxy);
            return mc;
        }
        catch (Exception e) {
            proc.kill();
            throw e;
        }
    }

    @Override
    public void println(MeshProcess process, String line) {
        byte[] data = (line + "\n").getBytes();
        try {
            process.write(0, data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public synchronized void setBootstrapClassLoader(ClassLoader classLoader) throws Exception {
        if (this.bootStrapClassLoader != classLoader) {
            this.bootStrapClassLoader = classLoader;
            this.bootStrapClassLoaderFactory = null;
        }
    }

    @Override
    public synchronized ClassLoader getBootstrapClassLoader() {
        if (this.bootStrapClassLoader == null) {
            this.bootStrapClassLoader = this.getClass().getClassLoader();
        }
        return this.bootStrapClassLoader;
    }

    @Override
    public synchronized void setBootstrapClassLoaderFactory(ClassLoaderFactory bootStrapClassLoaderFactory) {
        this.bootStrapClassLoaderFactory = bootStrapClassLoaderFactory;
    }

    @Override
    public synchronized ClassLoaderFactory getBootstrapClassLoaderFactory() {
        if (this.bootStrapClassLoaderFactory == null) {
            ClassLoader loader = this.getBootstrapClassLoader();
            if (this.classLoaderServer == null) {
                try {
                    this.classLoaderServer = ClassLoaderServerFactory.create("basic:", this.getMeshKeeper());
                    this.classLoaderServer.start();
                }
                catch (Exception e) {
                    throw new RuntimeException("Error creating classloader server", e);
                }
            }
            try {
                this.bootStrapClassLoaderFactory = this.classLoaderServer.export(loader, "/classloader/" + this.name, 100);
            }
            catch (Exception e) {
                throw new RuntimeException("Error creating classloader factory", e);
            }
        }
        return this.bootStrapClassLoaderFactory;
    }

    @Override
    public long getBindTimeout() {
        return this.bindTimeout;
    }

    @Override
    public void setBindTimeout(long bindTimeout) {
        this.bindTimeout = bindTimeout;
    }

    @Override
    public long getLaunchTimeout() {
        return this.launchTimeout;
    }

    @Override
    public void setLaunchTimeout(long launchTimeout) {
        this.launchTimeout = launchTimeout;
    }

    @Override
    public long getKillTimeout() {
        return this.killTimeout;
    }

    @Override
    public void setKillTimeout(long killTimeout) {
        this.killTimeout = killTimeout;
    }

    private synchronized void addWatchedProcess(MeshProcessWatcher watched) {
        this.runningProcesses.add(watched);
    }

    private synchronized void removeWatchedProcess(MeshProcessWatcher watched) {
        this.runningProcesses.remove(watched);
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void killRunningProcesses() {
        while (true) {
            MeshProcessWatcher[] running = null;
            LaunchClient launchClient = this;
            synchronized (launchClient) {
                if (this.runningProcesses.isEmpty()) {
                    return;
                }
                this.log.warn((Object)("Killing " + this.runningProcesses.size() + " processes"));
                running = new MeshProcessWatcher[this.runningProcesses.size()];
                running = this.runningProcesses.toArray(running);
            }
            for (MeshProcessWatcher w : running) {
                try {
                    w.getProcess().kill();
                }
                catch (Exception e) {
                    w.cleanup();
                }
            }
            launchClient = this;
            synchronized (launchClient) {
                while (!this.runningProcesses.isEmpty()) {
                    int count = this.runningProcesses.size();
                    try {
                        this.wait(this.killTimeout);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    if (count != this.runningProcesses.size()) continue;
                    this.log.warn((Object)"Timed out waiting to kill processes");
                    return;
                }
            }
        }
    }

    @Override
    public void ping() {
    }

    private class MeshProcessWatcher
    implements MeshProcessListener {
        private final MeshProcessListener delegate;
        private MeshProcessListener proxy = null;
        private AtomicBoolean running = new AtomicBoolean(true);
        private MeshProcess process;

        MeshProcessWatcher(MeshProcessListener delegate, String id) {
            this.delegate = delegate == null ? new DefaultProcessListener(id) : delegate;
        }

        public synchronized MeshProcessListener getProxy() throws Exception {
            if (this.proxy == null) {
                this.proxy = LaunchClient.this.meshKeeper.remoting().export(this, MeshProcessListener.class);
            }
            return this.proxy;
        }

        public synchronized void setProcess(MeshProcess process) {
            this.process = process;
        }

        public synchronized MeshProcess getProcess() {
            return this.process;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cleanup() {
            MeshProcessWatcher meshProcessWatcher = this;
            synchronized (meshProcessWatcher) {
                if (this.proxy != null) {
                    try {
                        LaunchClient.this.meshKeeper.remoting().unexport(this);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            LaunchClient.this.removeWatchedProcess(this);
        }

        public void onProcessError(Throwable thrown) {
            this.delegate.onProcessError(thrown);
        }

        public void onProcessExit(int exitCode) {
            this.delegate.onProcessExit(exitCode);
            this.running.set(false);
            this.cleanup();
        }

        public void onProcessInfo(String message) {
            this.delegate.onProcessInfo(message);
        }

        public void onProcessOutput(int fd, byte[] output) {
            this.delegate.onProcessOutput(fd, output);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MeshContainerImpl
    implements MeshContainer {
        private final MeshProcess process;
        private final MeshContainerService container;

        MeshContainerImpl(MeshProcess processProxy, MeshContainerService containerProxy) {
            this.process = processProxy;
            this.container = containerProxy;
        }

        @Override
        public <T extends Serializable> T host(String name, T object, Class<?> ... serviceInterfaces) throws Exception {
            return this.container.host(name, object, new Class[0]);
        }

        @Override
        public void unhost(String name) {
            try {
                this.container.unhost(name);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public <R extends Runnable & Serializable> void run(R r) throws Exception {
            this.container.run(r);
        }

        @Override
        public <T, C extends Callable<T> & Serializable> T call(C c) throws Exception {
            return this.container.call(c);
        }

        @Override
        public void close() {
            try {
                this.kill();
            }
            catch (Exception e) {
                LaunchClient.this.log.warn((Object)"error closing meshcontainer", (Throwable)e);
            }
        }

        @Override
        public void close(int fd) throws IOException {
            this.process.close(fd);
        }

        @Override
        public boolean isRunning() throws Exception {
            return this.process.isRunning();
        }

        @Override
        public void kill() throws Exception {
            this.container.close();
            this.process.kill();
        }

        @Override
        public void open(int fd) throws IOException {
            this.process.open(fd);
        }

        @Override
        public void write(int fd, byte[] data) throws IOException {
            this.process.write(fd, data);
        }
    }

    public static class MeshContainerLaunch
    extends JavaLaunch {
        private String regPath;
    }
}

