/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.meshkeeper.distribution;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.fusesource.meshkeeper.classloader.ClassLoaderServer;
import org.fusesource.meshkeeper.control.ControlService;
import org.fusesource.meshkeeper.distribution.DefaultDistributor;
import org.fusesource.meshkeeper.distribution.PluginResolver;
import org.fusesource.meshkeeper.distribution.event.EventClient;
import org.fusesource.meshkeeper.distribution.registry.RegistryClient;
import org.fusesource.meshkeeper.distribution.remoting.RemotingClient;
import org.fusesource.meshkeeper.distribution.repository.RepositoryClient;
import org.fusesource.meshkeeper.util.internal.FileSupport;
import org.fusesource.meshkeeper.util.internal.IOSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginClassLoader
extends URLClassLoader {
    private static final Log LOG = LogFactory.getLog(PluginClassLoader.class);
    private static final HashSet<String> SPI_PACKAGES = new HashSet();
    private static final HashSet<String> PARENT_FIRST = new HashSet();
    private static final String DEFAULT_PLUGIN_VERSION = PluginClassLoader.getDefaultPluginVersion();
    private static final PluginClassLoader DEFAULT_PLUGIN_CLASSLOADER = new PluginClassLoader(Thread.currentThread().getContextClassLoader());
    private static final boolean USE_PARENT_FIRST = false;
    private static PluginResolver PLUGIN_RESOLVER;
    private static final HashMap<String, List<File>> RESOLVED_PLUGINS;
    private final HashSet<String> resolvedFiles = new HashSet();

    public static final PluginClassLoader getDefaultPluginLoader() {
        return DEFAULT_PLUGIN_CLASSLOADER;
    }

    public static final PluginClassLoader getContextPluginLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl instanceof PluginClassLoader) {
            return (PluginClassLoader)cl;
        }
        return PluginClassLoader.getDefaultPluginLoader();
    }

    PluginClassLoader(ClassLoader parent) {
        super(new URL[0], parent);
    }

    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c == null) {
            int pDelim = name.lastIndexOf(".");
            if (pDelim > 0 && SPI_PACKAGES.contains(name.substring(0, pDelim))) {
                c = super.loadClass(name, resolve);
            } else {
                for (String prefix : PARENT_FIRST) {
                    if (!name.startsWith(prefix)) continue;
                    try {
                        c = super.loadClass(name, resolve);
                    }
                    catch (ClassNotFoundException cnfe) {}
                }
                if (c == null) {
                    try {
                        c = this.findClass(name);
                    }
                    catch (ClassNotFoundException cnfe) {
                        c = super.loadClass(name, resolve);
                    }
                }
            }
        }
        if (c == null) {
            throw new ClassNotFoundException(name);
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> c = super.findClass(name);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("PluginCL-" + this.hashCode() + " Found class: " + name));
        }
        return c;
    }

    @Override
    public URL getResource(String name) {
        URL url = this.findResource(name);
        if (url == null) {
            url = this.getParent().getResource(name);
        }
        return url;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> results = null;
        try {
            results = super.findResources(name);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (results == null || !results.hasMoreElements()) {
            results = this.getParent().getResources(name);
        }
        return results;
    }

    @Override
    public URL findResource(String name) {
        URL url = null;
        if (name.equals("log4j.properties") && (url = this.getParent().getResource(name)) != null) {
            return url;
        }
        url = super.findResource(name);
        if (LOG.isDebugEnabled()) {
            if (url == null) {
                LOG.debug((Object)("Couldn't find resource " + name + " in path: " + Arrays.toString(super.getURLs())));
            } else {
                LOG.debug((Object)("Looking for resource: " + name + " found: " + url));
            }
        }
        return url;
    }

    public void addUrl(URL url) {
        super.addURL(url);
    }

    public Class<?> loadPlugin(String path, String key) throws IOException, ClassNotFoundException {
        String uri = path + key;
        try {
            Properties properties = PluginClassLoader.loadProperties(this, uri);
            if (properties == null) {
                this.loadPlugin(key);
                properties = PluginClassLoader.loadProperties(this, uri);
            }
            if (properties == null) {
                throw new IOException("Could not find factory properties: " + uri);
            }
            String className = properties.getProperty("class");
            if (className == null) {
                throw new IOException("Expected property is missing: class");
            }
            String mavenArtifact = properties.getProperty("maven.artifact");
            if (mavenArtifact != null) {
                this.loadArtifact(mavenArtifact);
            }
            return this.loadClass(className);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (ClassNotFoundException cnfe) {
            throw cnfe;
        }
        catch (Exception e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties(ClassLoader cl, String uri) throws IOException {
        InputStream in = cl.getResourceAsStream(uri);
        if (in == null) {
            return null;
        }
        BufferedInputStream reader = new BufferedInputStream(in);
        try {
            Properties properties = new Properties();
            properties.load(reader);
            Properties properties2 = properties;
            return properties2;
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadArtifact(String artifactId) throws IOException, Exception {
        List<File> resolved = null;
        HashMap<String, List<File>> hashMap = RESOLVED_PLUGINS;
        synchronized (hashMap) {
            if (!RESOLVED_PLUGINS.containsKey(artifactId)) {
                LOG.info((Object)("Resolving plugin: " + artifactId));
                resolved = this.getPluginResolver().resolvePlugin(artifactId);
                RESOLVED_PLUGINS.put(artifactId, resolved);
                LOG.info((Object)("Resolved plugin: " + artifactId));
            } else {
                resolved = RESOLVED_PLUGINS.get(artifactId);
            }
        }
        for (File f : resolved) {
            if (!this.resolvedFiles.add(f.getCanonicalPath())) continue;
            LOG.debug((Object)("Adding plugin dependency: " + f.getCanonicalPath()));
            this.addUrl(f.toURL());
        }
    }

    private void loadPlugin(String key) throws IOException, Exception {
        String version = System.getProperty("meshkeeper.plugin.version." + key, DEFAULT_PLUGIN_VERSION);
        this.loadArtifact("org.fusesource.meshkeeper:meshkeeper-" + key + "-plugin:" + version);
    }

    private static String getDefaultPluginVersion() {
        String rc = System.getProperty("meshkeeper.plugin.version.default");
        if (rc != null) {
            return rc;
        }
        return PluginClassLoader.getModuleVersion();
    }

    public static String getModuleVersion() {
        String pomProps = "META-INF/maven/org.fusesource.meshkeeper/meshkeeper-api/pom.properties";
        String DEFAULT_VERSION = "LATEST";
        try {
            Properties p = PluginClassLoader.loadProperties(PluginClassLoader.class.getClassLoader(), pomProps);
            if (p != null) {
                return p.getProperty("version", "LATEST");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        LOG.warn((Object)("Unable to locate '" + pomProps + "' to determine plugin versions using default: " + "LATEST"));
        return "LATEST";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized PluginResolver getPluginResolver() {
        if (PLUGIN_RESOLVER == null) {
            PluginClassLoader loader = this;
            try {
                InputStream is = PluginClassLoader.class.getClassLoader().getResourceAsStream("meshkeeper-mop-resolver.jar");
                if (is != null) {
                    File tempJar = File.createTempFile("meshkeeper-mop-resolver", ".jar");
                    tempJar.deleteOnExit();
                    try {
                        FileSupport.write(is, tempJar);
                    }
                    finally {
                        IOSupport.close(is);
                    }
                    loader.addUrl(tempJar.toURL());
                }
                PLUGIN_RESOLVER = (PluginResolver)loader.loadClass("org.fusesource.meshkeeper.distribution.MopPluginResolver").newInstance();
            }
            catch (Throwable thrown) {
                LOG.error((Object)("Error loading plugin resolver:" + thrown.getMessage()), thrown);
                throw new RuntimeException(thrown);
            }
            PLUGIN_RESOLVER.setDefaultPluginVersion(PluginClassLoader.getDefaultPluginVersion());
        }
        return PLUGIN_RESOLVER;
    }

    static {
        RESOLVED_PLUGINS = new HashMap();
        SPI_PACKAGES.add(DefaultDistributor.class.getPackage().getName());
        SPI_PACKAGES.add(RemotingClient.class.getPackage().getName());
        SPI_PACKAGES.add(RepositoryClient.class.getPackage().getName());
        SPI_PACKAGES.add(RegistryClient.class.getPackage().getName());
        SPI_PACKAGES.add(EventClient.class.getPackage().getName());
        SPI_PACKAGES.add(ControlService.class.getPackage().getName());
        SPI_PACKAGES.add(ClassLoaderServer.class.getPackage().getName());
        PARENT_FIRST.add(LogFactory.class.getPackage().getName());
        PARENT_FIRST.add("org.apache.log4j");
        PARENT_FIRST.add("org.apache.maven");
        PARENT_FIRST.add("org.springframework");
        PARENT_FIRST.add("javax.jms");
    }
}

