/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.meshkeeper.distribution.event.vm;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.fusesource.meshkeeper.MeshEvent;
import org.fusesource.meshkeeper.MeshEventListener;
import org.fusesource.meshkeeper.distribution.event.AbstractEventClient;
import org.fusesource.meshkeeper.distribution.event.EventClient;
import org.fusesource.meshkeeper.distribution.event.vm.VMEventServer;

public class VMEventClient
extends AbstractEventClient
implements EventClient {
    private static final VMEventServer server = new VMEventServer();
    private final HashMap<String, HashSet<MeshEventListener>> eventListeners = new HashMap();
    private boolean closed = false;

    public void start() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws Exception {
        VMEventClient vMEventClient = this;
        synchronized (vMEventClient) {
            this.closed = true;
        }
        for (Map.Entry<String, HashSet<MeshEventListener>> entry : this.eventListeners.entrySet()) {
            for (MeshEventListener l : entry.getValue()) {
                server.closeEventListener(l, entry.getKey());
            }
        }
        this.eventListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeEventListener(MeshEventListener listener, String topic) throws Exception {
        boolean removed = false;
        VMEventClient vMEventClient = this;
        synchronized (vMEventClient) {
            this.checkClosed();
            HashSet<MeshEventListener> listeners = this.eventListeners.get(topic);
            if (listeners != null) {
                if (listeners.remove(listener)) {
                    removed = true;
                }
                if (listeners.isEmpty()) {
                    this.eventListeners.remove(topic);
                }
            }
        }
        if (removed) {
            server.closeEventListener(listener, topic);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openEventListener(MeshEventListener listener, String topic) throws Exception {
        boolean added = false;
        VMEventClient vMEventClient = this;
        synchronized (vMEventClient) {
            this.checkClosed();
            HashSet<MeshEventListener> listeners = this.eventListeners.get(topic);
            if (listeners == null) {
                listeners = new HashSet(1);
                this.eventListeners.put(topic, listeners);
            }
            if (listeners.add(listener)) {
                added = true;
            }
        }
        if (added) {
            server.openEventListener(listener, topic);
        }
    }

    public void sendEvent(MeshEvent event, String topic) throws Exception {
        this.checkClosed();
        server.sendEvent(event, topic);
    }

    private synchronized void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
    }
}

