/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.meshkeeper.distribution.event.vm;

import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.fusesource.meshkeeper.MeshEvent;
import org.fusesource.meshkeeper.MeshEventListener;
import org.fusesource.meshkeeper.control.ControlService;
import org.fusesource.meshkeeper.distribution.DistributorFactory;

public class VMEventServer
implements ControlService {
    private final HashMap<String, EventQueue> EVENT_QUEUES = new HashMap();
    private final ExecutorService EXECUTOR = DistributorFactory.getExecutorService();

    public synchronized void closeEventListener(MeshEventListener listener, String topic) throws Exception {
        EventQueue queue = this.EVENT_QUEUES.get(topic);
        if (queue != null) {
            queue.removeListener(listener);
            if (queue.canBeRemoved()) {
                this.EVENT_QUEUES.remove(topic);
            }
        }
    }

    public synchronized void openEventListener(MeshEventListener listener, String topic) throws Exception {
        EventQueue queue = this.EVENT_QUEUES.get(topic);
        if (queue == null) {
            queue = new EventQueue(topic);
            this.EVENT_QUEUES.put(topic, queue);
        }
        queue.addListener(listener);
    }

    public synchronized void sendEvent(MeshEvent event, String topic) throws Exception {
        EventQueue queue = this.EVENT_QUEUES.get(topic);
        if (queue != null) {
            queue.add(event);
        }
    }

    public void start() throws Exception {
    }

    public void destroy() throws Exception {
    }

    public String getName() {
        return "VMEventServer";
    }

    public String getServiceUri() {
        return "vm:" + this.getName();
    }

    public void setDirectory(String directory) {
    }

    private class EventQueue
    implements Runnable {
        final HashSet<MeshEventListener> listeners = new HashSet(1);
        final LinkedBlockingQueue<Runnable> eventQueue = new LinkedBlockingQueue();
        final AtomicBoolean scheduled = new AtomicBoolean(false);
        final String topic;

        EventQueue(String topic) {
            this.topic = topic;
        }

        public synchronized boolean canBeRemoved() {
            return this.listeners.isEmpty() && this.eventQueue.isEmpty();
        }

        public synchronized void addListener(MeshEventListener listener) {
            this.listeners.add(listener);
        }

        public synchronized void removeListener(MeshEventListener listener) {
            this.listeners.remove(listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(final MeshEvent event) {
            EventQueue eventQueue = this;
            synchronized (eventQueue) {
                if (this.listeners.isEmpty()) {
                    return;
                }
                final MeshEventListener[] targets = (MeshEventListener[])this.listeners.toArray();
                this.eventQueue.add(new Runnable(){

                    public void run() {
                        for (MeshEventListener t : targets) {
                            t.onEvent(event);
                        }
                    }
                });
            }
            this.schedule();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Runnable r = this.eventQueue.poll();
            if (r != null) {
                r.run();
            }
            this.scheduled.set(false);
            if (this.canBeRemoved()) {
                VMEventServer vMEventServer = VMEventServer.this;
                synchronized (vMEventServer) {
                    if (this.canBeRemoved()) {
                        VMEventServer.this.EVENT_QUEUES.remove(this.topic);
                    }
                }
            } else {
                this.schedule();
            }
        }

        private void schedule() {
            if (!(this.eventQueue.isEmpty() && !this.listeners.isEmpty() || this.scheduled.compareAndSet(false, true))) {
                VMEventServer.this.EXECUTOR.execute(this);
            }
        }
    }
}

