/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.meshkeeper.distribution.provisioner.embedded;

import java.io.File;
import java.io.FileInputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import org.fusesource.meshkeeper.MeshEvent;
import org.fusesource.meshkeeper.MeshKeeper;
import org.fusesource.meshkeeper.MeshKeeperFactory;
import org.fusesource.meshkeeper.control.ControlServer;
import org.fusesource.meshkeeper.distribution.provisioner.Provisioner;
import org.fusesource.meshkeeper.distribution.provisioner.embedded.EmbeddedServer;

public class EmbeddedProvisioner
implements Provisioner {
    private static EmbeddedServer EMBEDDED_SERVER;
    private static final Object SYNC;
    private boolean machineOwnerShip;
    private String deploymentUri;
    private int registryPort = 0;
    private int provisioningTimeout = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy() throws Provisioner.MeshProvisioningException {
        Object object = SYNC;
        synchronized (object) {
            if (EMBEDDED_SERVER == null) {
                EMBEDDED_SERVER = new EmbeddedServer();
                try {
                    EMBEDDED_SERVER.setDataDirectory(this.getControlServerDirectory());
                    EMBEDDED_SERVER.setRegistryPort(this.registryPort);
                    EMBEDDED_SERVER.start();
                }
                catch (Exception e) {
                    throw new Provisioner.MeshProvisioningException("Error starting embedded server", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unDeploy(boolean force) throws Provisioner.MeshProvisioningException {
        Object object = SYNC;
        synchronized (object) {
            if (EMBEDDED_SERVER != null) {
                try {
                    EMBEDDED_SERVER.stop();
                    EMBEDDED_SERVER = null;
                }
                catch (Exception e) {
                    throw new Provisioner.MeshProvisioningException("Error starting embedded server", e);
                }
            }
            MeshKeeper mesh = null;
            try {
                mesh = MeshKeeperFactory.createMeshKeeper(this.findMeshRegistryUri());
                mesh.eventing().sendEvent(new MeshEvent(ControlServer.ControlEvent.SHUTDOWN.ordinal(), this.getClass().getSimpleName(), null), "meshkeeper.control");
                File f = new File(MeshKeeperFactory.getDefaultServerDirectory(), "controller.properties");
                long timeout = System.currentTimeMillis() + 5000L;
                while (System.currentTimeMillis() < timeout && f.exists()) {
                    Thread.sleep(500L);
                }
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw new Provisioner.MeshProvisioningException("interrupted", ie);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public String findMeshRegistryUri() throws Provisioner.MeshProvisioningException {
        if (EMBEDDED_SERVER != null) {
            return EMBEDDED_SERVER.getRegistryUri();
        }
        try {
            Properties p = this.getFileProps();
            String registryUri = p.getProperty("meshkeeper.registry.uri");
            if (registryUri != null) {
                return registryUri;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new Provisioner.MeshProvisioningException("Embedded Server not started");
    }

    public String getDeploymentUri() {
        return "embedded:";
    }

    public String getPreferredControlHost() {
        try {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            return "localhost";
        }
    }

    public String[] getRequestedAgentHosts() {
        try {
            return new String[]{InetAddress.getLocalHost().getCanonicalHostName()};
        }
        catch (UnknownHostException e) {
            return new String[]{"localhost"};
        }
    }

    public synchronized StringBuffer getStatus(StringBuffer buffer) throws Provisioner.MeshProvisioningException {
        if (buffer == null) {
            buffer = new StringBuffer(512);
        }
        if (EMBEDDED_SERVER != null) {
            buffer.append("Embedded MeshKeeper is deployed at: " + this.findMeshRegistryUri());
        } else {
            buffer.append("Embedded MeshKeeper is not deployed\n");
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isDeployed() throws Provisioner.MeshProvisioningException {
        if (EMBEDDED_SERVER != null) {
            return true;
        }
        if (this.deploymentUri != null) {
            MeshKeeper mesh = null;
            try {
                mesh = MeshKeeperFactory.createMeshKeeper(this.findMeshRegistryUri());
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                boolean bl = false;
                return bl;
            }
            finally {
                if (mesh != null) {
                    try {
                        mesh.destroy();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return false;
    }

    File getControlServerDirectory() throws Exception {
        if (this.deploymentUri != null) {
            return new File(this.deploymentUri);
        }
        return MeshKeeperFactory.getDefaultServerDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getFileProps() throws Exception {
        File propFile = new File(this.getControlServerDirectory(), "controller.properties");
        if (propFile.exists()) {
            Properties props = new Properties();
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(propFile);
                props.load(fis);
            }
            finally {
                if (fis != null) {
                    fis.close();
                }
            }
            return props;
        }
        return null;
    }

    public void reDeploy(boolean force) throws Provisioner.MeshProvisioningException {
        this.unDeploy(true);
        this.deploy();
    }

    public void setDeploymentUri(String deploymentUri) {
        this.deploymentUri = deploymentUri;
    }

    public void setPreferredControlHost(String preferredControlHost) {
    }

    public void setRequestedAgentHosts(String[] agentHosts) {
    }

    public boolean getAgentMachineOwnership() {
        return this.machineOwnerShip;
    }

    public int getMaxAgents() {
        return -1;
    }

    public void setAgentMachineOwnership(boolean machineOwnerShip) {
        this.machineOwnerShip = machineOwnerShip;
    }

    public void setMaxAgents(int maxAgents) {
    }

    public void setRegistryPort(int port) {
        this.registryPort = port;
    }

    public long getProvisioningTimeout() {
        return this.provisioningTimeout;
    }

    public void setProvisioningTimeout(long provisioningTimeout) {
    }

    static {
        SYNC = new Object();
    }
}

