/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.meshkeeper.distribution.provisioner.embedded;

import java.io.File;
import org.fusesource.meshkeeper.MeshKeeperFactory;
import org.fusesource.meshkeeper.control.ControlServer;

public class EmbeddedServer {
    ControlServer controlServer;
    File dataDirectory;
    String registryURI;
    private int registryPort = 0;

    public File getDataDirectory() {
        return this.dataDirectory;
    }

    public void setDataDirectory(File dataDirectory) {
        this.dataDirectory = dataDirectory;
    }

    public void start() throws Exception {
        if (this.registryURI != null) {
            return;
        }
        this.registryURI = "zk:tcp://0.0.0.0:" + this.registryPort;
        if (this.dataDirectory == null) {
            this.dataDirectory = MeshKeeperFactory.getDefaultServerDirectory();
        }
        this.controlServer = MeshKeeperFactory.createControlServer(this.registryURI, this.dataDirectory);
        this.registryURI = this.controlServer.getRegistryConnectUri();
        this.controlServer.setEmbeddedLaunchAgent(MeshKeeperFactory.createAgent(this.controlServer.getMeshKeeper(), this.dataDirectory));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        Exception first = null;
        try {
            this.controlServer.destroy();
        }
        catch (Exception e) {
            first = first == null ? e : first;
        }
        finally {
            this.controlServer = null;
            this.registryURI = null;
        }
    }

    public String getRegistryUri() {
        if (this.controlServer != null) {
            return this.controlServer.getRegistryConnectUri();
        }
        return this.registryURI;
    }

    public void setRegistryPort(int registryPort) {
        this.registryPort = registryPort;
    }
}

