/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.meshkeeper.distribution.registry;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.fusesource.meshkeeper.RegistryWatcher;
import org.fusesource.meshkeeper.distribution.registry.RegistryClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistryHelper {
    private static final Log LOG = LogFactory.getLog(RegistryHelper.class);

    public static <T> Collection<T> waitForRegistrations(RegistryClient reg, String path, int min, long timeout) throws TimeoutException, Exception {
        return new RegistrationWatcher(path, null, reg).waitForRegistrations(min, timeout).values();
    }

    public static <T> T waitForRegistration(RegistryClient reg, String path, long timeout) throws TimeoutException, Exception {
        String parentPath = path.substring(0, path.lastIndexOf("/"));
        String node = path.substring(path.lastIndexOf("/") + 1);
        HashSet<String> filters = new HashSet<String>();
        filters.add(node);
        return new RegistrationWatcher(parentPath, filters, reg).waitForRegistrations(1, timeout).get(node);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RegistrationWatcher<T>
    implements RegistryWatcher {
        final HashMap<String, T> map = new HashMap();
        RegistryClient registry;
        String path;
        Set<String> filters;

        RegistrationWatcher(String path, Set<String> filters, RegistryClient registry) throws Exception {
            this.path = path;
            this.registry = registry;
            this.filters = filters;
            registry.addRegistryWatcher(path, this);
        }

        @Override
        public synchronized void onChildrenChanged(String path, List<String> nodes) {
            for (String node : nodes) {
                if (!this.filter(node) || this.map.containsKey(node)) continue;
                try {
                    Object o = this.registry.getRegistryObject(path + "/" + node);
                    this.map.put(node, o);
                }
                catch (Throwable e) {
                    LOG.error((Object)("Error retrieving registry object at " + path + "/" + node), e);
                }
            }
            this.map.keySet().retainAll(nodes);
            this.notifyAll();
        }

        private boolean filter(String node) {
            if (this.filters == null) {
                return true;
            }
            return this.filters.contains(node);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map<String, T> waitForRegistrations(int min, long timeout) throws InterruptedException, TimeoutException {
            try {
                RegistrationWatcher registrationWatcher = this;
                synchronized (registrationWatcher) {
                    long started = System.currentTimeMillis();
                    while (timeout > 0L && this.map.size() < min) {
                        this.wait(timeout);
                        timeout -= System.currentTimeMillis() - started;
                    }
                    if (this.map.size() < min) {
                        throw new TimeoutException();
                    }
                }
            }
            finally {
                try {
                    this.registry.removeRegistryWatcher(this.path, this);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return this.map;
        }
    }
}

