/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.meshkeeper.distribution.registry.vm;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.fusesource.meshkeeper.RegistryWatcher;
import org.fusesource.meshkeeper.distribution.registry.AbstractRegistryClient;
import org.fusesource.meshkeeper.distribution.registry.vm.VMRegistryServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VMRegistry
extends AbstractRegistryClient {
    private static final VMRegistryServer SERVER = new VMRegistryServer();
    private HashMap<String, HashSet<RegistryWatcher>> watchers = new HashMap();
    AtomicBoolean started = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws Exception {
        this.started.compareAndSet(false, true);
        VMRegistry vMRegistry = this;
        synchronized (vMRegistry) {
            for (Map.Entry<String, HashSet<RegistryWatcher>> e : this.watchers.entrySet()) {
                for (RegistryWatcher w : e.getValue()) {
                    SERVER.removeRegistryWatcher(e.getKey(), w);
                }
            }
            this.watchers.clear();
        }
    }

    @Override
    public void destroy() throws Exception {
        this.started.set(false);
    }

    @Override
    public String addRegistryData(String path, boolean sequential, byte[] data) throws Exception {
        this.checkStarted();
        return SERVER.addData(path, sequential, data);
    }

    @Override
    public String addRegistryObject(String path, boolean sequential, Serializable o) throws Exception {
        this.checkStarted();
        return SERVER.addObject(path, sequential, o);
    }

    @Override
    public <T> T getRegistryObject(String path) throws Exception {
        this.checkStarted();
        return SERVER.getObject(path);
    }

    @Override
    public byte[] getRegistryData(String path) throws Exception {
        this.checkStarted();
        return SERVER.getData(path);
    }

    @Override
    public void removeRegistryData(String path, boolean recursive) throws Exception {
        this.checkStarted();
        SERVER.remove(path, recursive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRegistryWatcher(String path, RegistryWatcher watcher) throws Exception {
        this.checkStarted();
        boolean added = false;
        VMRegistry vMRegistry = this;
        synchronized (vMRegistry) {
            HashSet<RegistryWatcher> registered = this.watchers.get(path);
            if (registered == null) {
                registered = new HashSet();
                this.watchers.put(path, registered);
            }
            if (registered.add(watcher)) {
                added = true;
            }
        }
        if (added) {
            SERVER.addRegistryWatcher(path, watcher);
        }
    }

    @Override
    public Collection<String> list(String path, boolean recursive, String ... filters) throws Exception {
        return SERVER.list(path, recursive, filters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void removeRegistryWatcher(String path, RegistryWatcher watcher) throws Exception {
        this.checkStarted();
        boolean removed = false;
        VMRegistry vMRegistry = this;
        synchronized (vMRegistry) {
            HashSet<RegistryWatcher> registered = this.watchers.get(path);
            if (registered != null && registered.remove(watcher)) {
                removed = true;
            }
        }
        if (removed) {
            SERVER.removeRegistryWatcher(path, watcher);
        }
    }

    private void checkStarted() throws Exception {
        if (!this.started.get()) {
            throw new Exception("Not Connected");
        }
    }
}

