/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.meshkeeper.distribution.registry.vm;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.fusesource.meshkeeper.RegistryWatcher;
import org.fusesource.meshkeeper.control.ControlService;
import org.fusesource.meshkeeper.distribution.DistributorFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VMRegistryServer
implements ControlService {
    private static final ExecutorService EXECUTOR = DistributorFactory.getExecutorService();
    private final AtomicBoolean started = new AtomicBoolean(false);
    VMRNode root = new VMRNode();

    public synchronized String addData(String path, boolean sequential, byte[] data) throws Exception {
        this.checkStarted();
        VMRNode parent = this.createParentPath(path);
        String name = path.substring(path.lastIndexOf("/"));
        if (!sequential && parent.children.containsKey(name)) {
            throw new Exception("Node Already Exists: " + path);
        }
        VMRNode node = parent.createChild(path.substring(path.lastIndexOf("/")), sequential, data);
        return node.getFullPath();
    }

    public synchronized String addObject(String path, boolean sequential, Serializable o) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream os = new ObjectOutputStream(baos);
        os.writeObject(o);
        os.close();
        return this.addData(path, sequential, baos.toByteArray());
    }

    public <T> T getObject(String path) throws Exception {
        byte[] data = this.getData(path);
        if (data == null) {
            return null;
        }
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(data));
        return (T)in.readObject();
    }

    public synchronized byte[] getData(String path) throws Exception {
        VMRNode node = this.findNode(path);
        if (node == null) {
            return null;
        }
        return node.data;
    }

    public synchronized void remove(String path, boolean recursive) throws Exception {
        VMRNode node = this.findNode(path);
        if (node != null) {
            if (node.hasChildren()) {
                throw new Exception("Node Not Empty: " + path);
            }
            if (node.hasData()) {
                node.data = null;
            }
            if (node.isOkToDelete()) {
                node.delete(true);
            }
        }
    }

    public synchronized void addRegistryWatcher(String path, RegistryWatcher watcher) throws Exception {
        this.checkStarted();
        VMRNode node = this.createParentPath(path + "/");
        node.addRegistryWatcher(watcher);
    }

    public synchronized void removeRegistryWatcher(String path, RegistryWatcher watcher) {
        VMRNode node = this.findNode(path);
        if (node != null) {
            node.removeRegistryWatcher(watcher);
        }
    }

    public Collection<String> list(String path, boolean recursive, String ... filters) {
        if (filters != null) {
            HashSet<String> filterSet = new HashSet<String>();
            filterSet.addAll(Arrays.asList(filters));
            return this.list(path, recursive, new LinkedList<String>(), filterSet);
        }
        return this.list(path, recursive, new LinkedList<String>(), Collections.EMPTY_SET);
    }

    private Collection<String> list(String path, boolean recursive, Collection<String> results, Set<String> filters) {
        VMRNode node = this.findNode(path);
        if (node != null) {
            if (node.data != null) {
                results.add(node.getFullPath());
            }
            if (recursive && node.children != null) {
                for (VMRNode child : node.children.values()) {
                    if (filters.remove(child.getFullPath())) continue;
                    this.list(child.getFullPath(), recursive, results, filters);
                }
            }
        }
        return results;
    }

    private VMRNode createParentPath(String path) throws Exception {
        StringTokenizer tok = new StringTokenizer(path, "/");
        VMRNode parent = this.root;
        while (tok.countTokens() > 1) {
            parent.createChild(tok.nextToken(), false, null);
        }
        return parent;
    }

    private VMRNode findNode(String path) {
        path = path.trim();
        StringTokenizer tok = new StringTokenizer(path, "/");
        for (VMRNode node = this.root; node != null && tok.hasMoreTokens(); node = node.getChild(tok.nextToken())) {
        }
        return this.root;
    }

    private void checkStarted() throws Exception {
        if (!this.started.get()) {
            throw new Exception("Not Connected");
        }
    }

    @Override
    public void destroy() throws Exception {
    }

    @Override
    public void start() throws Exception {
    }

    @Override
    public String getName() {
        return "VMRegistryServer";
    }

    @Override
    public String getServiceUri() {
        return "vm:" + this.getName();
    }

    @Override
    public void setDirectory(String directory) {
    }

    public class VMRNode {
        VMRNode parent;
        HashMap<String, VMRNode> children;
        String name = "";
        String path = "/";
        boolean sequential;
        byte[] data;
        HashSet<RegistryWatcher> watchers;

        public VMRNode createChild(String name, boolean sequential, byte[] data) throws Exception {
            if (this.sequential) {
                throw new Exception("Can't create child for sequential node");
            }
            if (this.children == null) {
                this.children = new HashMap();
            } else {
                VMRNode existing = this.children.get(name);
                if (existing != null) {
                    return existing;
                }
            }
            VMRNode rc = new VMRNode();
            rc.parent = this;
            rc.path = this.path + this.name + "/";
            rc.name = name;
            rc.sequential = sequential;
            rc.data = data;
            this.children.put(name, rc);
            this.fireRegistryWatcher();
            return rc;
        }

        public void removeChild(String name) {
            if (this.children == null) {
                return;
            }
            if (this.children.remove(name) != null && this.children.isEmpty()) {
                this.children = null;
            }
        }

        public VMRNode getChild(String name) {
            if (this.children == null) {
                return null;
            }
            return this.children.get(name);
        }

        public String getFullPath() {
            return this.path + "/" + this.name;
        }

        public boolean hasChildren() {
            return this.children != null && !this.children.isEmpty();
        }

        public boolean hasData() {
            return this.data != null;
        }

        public boolean hasWatchers() {
            return this.watchers != null && !this.watchers.isEmpty();
        }

        public boolean isOkToDelete() {
            return !this.hasChildren() && !this.hasWatchers();
        }

        public void delete(boolean deleteEmptyAncestors) {
            if (this.parent != null) {
                this.parent.removeChild(this.name);
                this.parent.fireRegistryWatcher();
                if (deleteEmptyAncestors && this.parent.isOkToDelete() && !this.parent.hasData()) {
                    this.parent.delete(deleteEmptyAncestors);
                }
            }
        }

        public void addRegistryWatcher(RegistryWatcher watcher) {
            if (this.watchers == null) {
                this.watchers = new HashSet(1);
            }
            this.watchers.add(watcher);
            this.fireWatchEvent(new RegistryWatcher[]{watcher});
        }

        public void removeRegistryWatcher(RegistryWatcher watcher) {
            if (this.watchers != null && this.watchers.remove(watcher) && this.watchers.isEmpty()) {
                this.watchers = null;
                if (!this.hasData() && this.isOkToDelete()) {
                    this.delete(true);
                }
            }
        }

        private void fireRegistryWatcher() {
            if (this.watchers != null) {
                this.fireWatchEvent((RegistryWatcher[])this.watchers.toArray());
            }
        }

        private void fireWatchEvent(final RegistryWatcher[] targets) {
            EXECUTOR.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    ArrayList<String> childList = new ArrayList<String>();
                    VMRegistryServer vMRegistryServer = VMRegistryServer.this;
                    synchronized (vMRegistryServer) {
                        if (VMRNode.this.children != null) {
                            childList.addAll(VMRNode.this.children.keySet());
                        }
                    }
                    for (RegistryWatcher w : targets) {
                        w.onChildrenChanged(VMRNode.this.getFullPath(), childList);
                    }
                }
            });
        }
    }
}

