/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.meshkeeper.distribution.remoting;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.fusesource.meshkeeper.Distributable;
import org.fusesource.meshkeeper.distribution.AbstractPluginClient;
import org.fusesource.meshkeeper.distribution.remoting.RemotingClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRemotingClient
extends AbstractPluginClient
implements RemotingClient {
    protected static final Log LOG = LogFactory.getLog(AbstractRemotingClient.class);

    protected abstract <T> T exportInterfaces(T var1, String var2, Class<?>[] var3) throws Exception;

    @Override
    public final <T> T export(T obj, Class<?> ... serviceInterfaces) throws Exception {
        return this.exportInternal(obj, null, serviceInterfaces);
    }

    @Override
    public final <T> T exportMulticast(T obj, String address, Class<?> ... serviceInterfaces) throws Exception {
        return this.exportInternal(obj, address, serviceInterfaces);
    }

    private final <T> T exportInternal(T obj, String multicastAddress, Class<?> ... serviceInterfaces) throws Exception {
        LinkedHashSet interfaces = new LinkedHashSet();
        if (serviceInterfaces == null || serviceInterfaces.length == 0) {
            AbstractRemotingClient.collectDistributableInterfaces(obj.getClass(), interfaces);
        } else {
            for (Class<?> serviceInterface : serviceInterfaces) {
                AbstractRemotingClient.validateInterface(serviceInterface);
                interfaces.add(serviceInterface);
            }
        }
        if (interfaces.size() == 0 || interfaces.size() == 1 && interfaces.contains(Distributable.class)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Exporting " + obj.getClass() + " with no service interfaces"));
            }
            return this.exportInterfaces(obj, multicastAddress, null);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Exporting " + obj.getClass() + " as: " + interfaces));
        }
        Class[] distributable = null;
        distributable = new Class[interfaces.size()];
        interfaces.toArray(distributable);
        return this.exportInterfaces(obj, multicastAddress, distributable);
    }

    protected static void validateInterface(Class<?> i) {
        if (!i.isInterface()) {
            throw new IllegalArgumentException("Not an interface: " + i);
        }
    }

    private static void collectDistributableInterfaces(Class<?> clazz, Set<Class<?>> rc) throws Exception {
        for (Class<?> interf : clazz.getInterfaces()) {
            if (!Distributable.class.isAssignableFrom(interf)) continue;
            AbstractRemotingClient.validateInterface(interf);
            rc.add(interf);
        }
        if (clazz.getSuperclass() != null) {
            AbstractRemotingClient.collectDistributableInterfaces(clazz.getSuperclass(), rc);
        }
    }
}

