/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.meshkeeper.launcher;

import java.net.InetAddress;
import java.util.Properties;
import org.fusesource.meshkeeper.HostProperties;
import org.fusesource.meshkeeper.launcher.LaunchAgent;

class HostPropertiesImpl
implements HostProperties {
    private static final long serialVersionUID = 1L;
    public String os;
    public int numProcessors;
    public String defaultHostName;
    public String defaultExternalHostName;
    public String directory;
    private Properties systemProperties;
    private String agentId;

    HostPropertiesImpl() {
    }

    void fillIn(LaunchAgent launcher) throws Exception {
        this.agentId = launcher.getAgentId();
        this.systemProperties = System.getProperties();
        this.directory = launcher.getDirectory().getCanonicalPath();
        this.defaultExternalHostName = this.defaultHostName = InetAddress.getLocalHost().getHostName();
        this.numProcessors = Runtime.getRuntime().availableProcessors();
        this.os = System.getProperty("os.name");
    }

    public String getAgentId() {
        return this.agentId;
    }

    public String getOS() {
        return this.os;
    }

    public int getNumProcessors() {
        return this.numProcessors;
    }

    public String getDefaultHostName() {
        return this.defaultHostName;
    }

    public String getExternalHostName() {
        return this.defaultExternalHostName;
    }

    public String getDirectory() {
        return this.directory;
    }

    public Properties getSystemProperties() {
        return this.systemProperties;
    }
}

