/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.meshkeeper.launcher;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.fusesource.meshkeeper.HostProperties;
import org.fusesource.meshkeeper.LaunchDescription;
import org.fusesource.meshkeeper.MeshKeeper;
import org.fusesource.meshkeeper.MeshKeeperFactory;
import org.fusesource.meshkeeper.MeshProcess;
import org.fusesource.meshkeeper.MeshProcessListener;
import org.fusesource.meshkeeper.launcher.HostPropertiesImpl;
import org.fusesource.meshkeeper.launcher.LaunchAgentService;
import org.fusesource.meshkeeper.launcher.LaunchClientService;
import org.fusesource.meshkeeper.launcher.LocalProcess;
import org.fusesource.meshkeeper.launcher.PortReserver;
import org.fusesource.meshkeeper.util.internal.FileSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LaunchAgent
implements LaunchAgentService {
    public static final long CLEANUP_TIMEOUT = 60000L;
    public static final String LOCAL_REPO_PROP = "org.fusesource.testrunner.localRepoDir";
    public static final Log LOG = LogFactory.getLog(LaunchAgent.class);
    public static final String[] PROPAGATED_SYSTEM_PROPERTIES = new String[]{"meshkeeper.home", "meshkeeper.base", "mop.base", "mop.online", "mop.allways-check-local-repo"};
    private String exclusiveOwner;
    private String agentId;
    private boolean started = false;
    private File directory = MeshKeeperFactory.getDefaultAgentDirectory();
    private final Map<Integer, LocalProcess> processes = new HashMap<Integer, LocalProcess>();
    int pidCounter = 0;
    private Thread shutdownHook;
    private HostPropertiesImpl properties = new HostPropertiesImpl();
    private Monitor monitor = new Monitor(this);
    private MeshKeeper meshKeeper;

    @Override
    public List<Integer> reserveTcpPorts(int count) throws Exception {
        return Arrays.asList(PortReserver.reservePorts((short)0, count));
    }

    @Override
    public void releaseTcpPorts(Collection<Integer> ports) {
        PortReserver.releasePorts((short)0, ports);
    }

    @Override
    public synchronized void bind(String owner) throws Exception {
        if (this.exclusiveOwner == null) {
            this.exclusiveOwner = owner;
            LOG.info((Object)("Now bound to: " + this.exclusiveOwner));
        } else if (!this.exclusiveOwner.equals(owner)) {
            throw new Exception("Bind failure, already bound: " + this.exclusiveOwner);
        }
    }

    @Override
    public synchronized void unbind(String owner) throws Exception {
        if (this.exclusiveOwner != null) {
            if (this.exclusiveOwner.equals(owner)) {
                LOG.info((Object)("Bind to " + this.exclusiveOwner + " released"));
                this.exclusiveOwner = null;
            } else {
                throw new Exception("Release failure, different owner: " + this.exclusiveOwner);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MeshProcess launch(LaunchDescription launchDescription, String sourceRegistryPath, MeshProcessListener handler) throws Exception {
        this.checkForRogueProcesses(10000);
        LaunchAgent launchAgent = this;
        synchronized (launchAgent) {
            int pid = this.pidCounter++;
            LocalProcess rc = this.createLocalProcess(launchDescription, handler, pid);
            rc.setOwnerRegistryPath(sourceRegistryPath);
            this.processes.put(pid, rc);
            try {
                rc.start();
            }
            catch (Exception e) {
                this.processes.remove(pid);
                throw e;
            }
            return rc.getProxy();
        }
    }

    protected LocalProcess createLocalProcess(LaunchDescription launchDescription, MeshProcessListener handler, int pid) throws Exception {
        return new LocalProcess(this, launchDescription, handler, pid);
    }

    public synchronized void start() throws Exception {
        if (this.started) {
            return;
        }
        System.getProperties().setProperty(LOCAL_REPO_PROP, this.meshKeeper.repository().getLocalRepoDirectory().getCanonicalPath());
        this.started = true;
        if (this.agentId == null) {
            try {
                this.setAgentId(InetAddress.getLocalHost().getHostName());
            }
            catch (UnknownHostException uhe) {
                LOG.warn((Object)"Error determining hostname.");
                uhe.printStackTrace();
                this.setAgentId("UNDEFINED");
            }
        }
        this.shutdownHook = new Thread(this.getAgentId() + "-Shutdown"){

            public void run() {
                LOG.debug((Object)("Executing Shutdown Hook for " + LaunchAgent.this));
                try {
                    LaunchAgent.this.stop();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        this.properties.fillIn(this);
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        this.monitor.start();
        this.meshKeeper.distribute(this.getRegistryPath(), false, this, new Class[0]);
        LOG.info((Object)("PROCESS LAUNCHER " + this.getAgentId() + " STARTED\n"));
    }

    private String getRegistryPath() {
        return "/meshkeeper/launch-agents/" + this.getAgentId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        LaunchAgent launchAgent = this;
        synchronized (launchAgent) {
            if (!this.started) {
                return;
            }
            if (Thread.currentThread() != this.shutdownHook) {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
            this.started = false;
            for (LocalProcess process : this.processes.values()) {
                try {
                    process.kill();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.processes.clear();
        }
        this.monitor.requestCleanup();
        this.monitor.stop();
        this.meshKeeper.undistribute(this);
        launchAgent = this;
        synchronized (launchAgent) {
            this.notifyAll();
        }
    }

    public synchronized void join() throws InterruptedException {
        this.wait();
    }

    public void purgeResourceRepository() throws IOException {
        this.meshKeeper.repository().purgeLocalRepo();
    }

    public void setDirectory(File directory) {
        this.directory = directory;
    }

    public File getDirectory() {
        return this.directory;
    }

    @Override
    public HostProperties getHostProperties() {
        return this.properties;
    }

    public void setAgentId(String id) {
        if (this.agentId == null && id != null) {
            this.agentId = id.trim().toUpperCase();
        }
    }

    public String getAgentId() {
        return this.agentId;
    }

    public MeshKeeper getMeshKeeper() {
        return this.meshKeeper;
    }

    public void setMeshKeeper(MeshKeeper meshKeeper) {
        this.meshKeeper = meshKeeper;
    }

    public Map<Integer, LocalProcess> getProcesses() {
        return this.processes;
    }

    public String toString() {
        return "ProcessLauncer-" + this.getAgentId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkForRogueProcesses(int timeout) {
        ArrayList<LocalProcess> runningProcs = null;
        LaunchAgent launchAgent = this;
        synchronized (launchAgent) {
            runningProcs = new ArrayList<LocalProcess>(this.processes.size());
            runningProcs.addAll(this.processes.values());
        }
        HashSet<String> deadLaunchers = new HashSet<String>();
        HashSet<String> runningLaunchers = new HashSet<String>();
        for (LocalProcess p : runningProcs) {
            if (runningLaunchers.contains(runningLaunchers.contains(p.getOwnerRegistryPath()))) continue;
            if (!deadLaunchers.contains(p.getOwnerRegistryPath())) {
                LaunchClientService launcher = null;
                try {
                    launcher = (LaunchClientService)this.meshKeeper.registry().getRegistryObject(p.getOwnerRegistryPath());
                }
                catch (Exception e) {
                    LOG.warn((Object)("Error looking up LaunchClient: " + p.getOwnerRegistryPath()), (Throwable)e);
                }
                if (launcher != null) {
                    runningLaunchers.add(p.getOwnerRegistryPath());
                    continue;
                }
                deadLaunchers.add(p.getOwnerRegistryPath());
            }
            LOG.warn((Object)("Killing rogue process:  " + p));
            try {
                p.kill();
            }
            catch (Exception e) {
                LOG.error((Object)"", (Throwable)e);
            }
        }
    }

    public synchronized void onProcessExit(LocalProcess process, int exitValue) {
        LOG.info((Object)(process + " exited with: " + exitValue));
        this.processes.remove(process.getPid());
    }

    private class Monitor
    implements Runnable {
        Log log = LogFactory.getLog(this.getClass());
        private final LaunchAgent processLauncher;
        Thread thread;
        private String tempDirectory;
        private boolean cleanupRequested = false;

        public Monitor(LaunchAgent processLauncher) {
            this.processLauncher = processLauncher;
        }

        public void start() {
            this.tempDirectory = this.processLauncher.getDirectory() + File.separator + this.processLauncher.getAgentId() + File.separator + "temp";
            this.thread = new Thread((Runnable)this, this.processLauncher.getAgentId() + "-Process Monitor");
            this.thread.start();
        }

        public void stop() {
            this.thread.interrupt();
            try {
                this.thread.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                Monitor monitor = this;
                synchronized (monitor) {
                    try {
                        this.wait(60000L);
                    }
                    catch (InterruptedException ie) {
                        this.cleanupRequested = true;
                        return;
                    }
                    finally {
                        this.processLauncher.checkForRogueProcesses(15000);
                        if (this.cleanupRequested) {
                            this.cleanUpTempFiles();
                            this.cleanupRequested = false;
                        }
                    }
                }
            }
        }

        public void cleanUpTempFiles() {
            Map<Integer, LocalProcess> processes = this.processLauncher.getProcesses();
            if (processes == null || processes.size() == 0) {
                File tempDir = new File(this.tempDirectory);
                String[] subDirs = tempDir != null ? tempDir.list() : null;
                this.log.debug((Object)"*************Cleaning up temporary parts*************");
                for (int i = 0; subDirs != null && i < subDirs.length; ++i) {
                    try {
                        FileSupport.recursiveDelete(tempDir + File.separator + subDirs[i]);
                        continue;
                    }
                    catch (Exception e) {
                        this.log.warn((Object)"ERROR cleaning up temporary parts:", (Throwable)e);
                    }
                }
            }
        }

        public synchronized void requestCleanup() {
            this.cleanupRequested = true;
            this.notify();
        }
    }
}

