/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.meshkeeper.launcher;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.fusesource.meshkeeper.Expression;
import org.fusesource.meshkeeper.LaunchDescription;
import org.fusesource.meshkeeper.LaunchTask;
import org.fusesource.meshkeeper.MeshKeeper;
import org.fusesource.meshkeeper.MeshProcess;
import org.fusesource.meshkeeper.MeshProcessListener;
import org.fusesource.meshkeeper.launcher.LaunchAgent;
import org.fusesource.meshkeeper.util.internal.ProcessSupport;

public class LocalProcess
implements MeshProcess {
    Log log = LogFactory.getLog(this.getClass());
    int FD_STD_IN = 0;
    int FD_STD_OUT = 1;
    int FD_STD_ERR = 2;
    private final Object mutex = new Object();
    private final LaunchDescription ld;
    protected final MeshProcessListener listener;
    private final int pid;
    Process process;
    private OutputStream os;
    AtomicBoolean running = new AtomicBoolean();
    private LaunchAgent processLauncher;
    Properties processProperties;
    private String ownerRegistryPath;
    private MeshKeeper.DistributionRef<MeshProcess> distributionRef;

    public LocalProcess(LaunchAgent processLauncher, LaunchDescription ld, MeshProcessListener listener, int pid) {
        this.processLauncher = processLauncher;
        this.ld = ld;
        this.listener = listener;
        this.pid = pid;
        this.processProperties = new Properties(processLauncher.getHostProperties().getSystemProperties());
    }

    public MeshProcess getProxy() {
        if (this.distributionRef == null) {
            return null;
        }
        return this.distributionRef.getProxy();
    }

    public Properties getProcessProperties() {
        return this.processProperties;
    }

    public LaunchAgent getProcessLauncher() {
        return this.processLauncher;
    }

    public MeshProcessListener getListener() {
        return this.listener;
    }

    public void setOwnerRegistryPath(String path) {
        this.ownerRegistryPath = path;
    }

    public String getOwnerRegistryPath() {
        return this.ownerRegistryPath;
    }

    public int getPid() {
        return this.pid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        if (this.ld.getCommand().isEmpty()) {
            throw new Exception("LaunchDescription command empty.");
        }
        for (LaunchTask task : this.ld.getPreLaunchTasks()) {
            task.execute(this);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Evaluating launch command with properties: " + this.processProperties));
        }
        ArrayList<String> cmdList = new ArrayList<String>(this.ld.getCommand().size());
        StringBuilder command_line = new StringBuilder();
        boolean first = true;
        for (Expression expression : this.ld.getCommand()) {
            String arg = expression.evaluate(this.processProperties);
            if (arg == null || arg.length() == 0) continue;
            if (!first) {
                command_line.append(" ");
            }
            first = false;
            cmdList.add(arg);
            command_line.append('\'');
            command_line.append(arg);
            command_line.append('\'');
        }
        String[] cmdArray = cmdList.toArray(new String[0]);
        String[] env = null;
        int i = 0;
        if (this.ld.getEnvironment() != null) {
            env = new String[this.ld.getEnvironment().size()];
            i = 0;
            for (Map.Entry<String, Expression> entry : this.ld.getEnvironment().entrySet()) {
                env[i++] = entry.getKey() + "=" + entry.getValue().evaluate();
            }
        }
        File workingDirectory = this.ld.getWorkingDirectory() != null ? new File(this.ld.getWorkingDirectory().evaluate()) : new File(this.processLauncher.getDirectory(), "pid-" + this.pid);
        workingDirectory.mkdirs();
        String msg = "Launching as: " + command_line + " [pid = " + this.pid + "] [workDir = " + workingDirectory + "]";
        this.log.info((Object)msg);
        if (this.listener != null) {
            this.listener.onProcessInfo(msg);
        }
        Object object = this.mutex;
        synchronized (object) {
            this.process = Runtime.getRuntime().exec(cmdArray, env, workingDirectory);
            if (this.process == null) {
                throw new Exception("Process launched failed (returned null).");
            }
            this.running.set(true);
            this.os = this.process.getOutputStream();
            ProcessSupport.watch("" + this.pid, this.process, new OutputHandler(this.FD_STD_OUT), new OutputHandler(this.FD_STD_ERR), new Runnable(){

                public void run() {
                    int exitValue = LocalProcess.this.process.exitValue();
                    LocalProcess.this.onExit(exitValue);
                }
            });
        }
        String regPath = "/meshkeeper/processes/" + this.processLauncher.getAgentId() + "/" + this.ownerRegistryPath.substring(1 + this.ownerRegistryPath.lastIndexOf("/"));
        this.distributionRef = this.processLauncher.getMeshKeeper().distribute(regPath + "/pid-" + this.pid, false, this, MeshProcess.class);
    }

    protected void onExit(int exitValue) {
        if (this.running.compareAndSet(true, false)) {
            block4: {
                if (this.listener != null) {
                    this.listener.onProcessExit(exitValue);
                }
                try {
                    this.processLauncher.getMeshKeeper().undistribute(this);
                }
                catch (Exception e) {
                    if (!this.log.isDebugEnabled()) break block4;
                    this.log.debug((Object)("Error undistributing " + this), (Throwable)e);
                }
            }
            this.processLauncher.onProcessExit(this, exitValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Object object = this.mutex;
        synchronized (object) {
            return this.process != null;
        }
    }

    public void kill() throws Exception {
        if (this.running.get()) {
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Killing process " + this.process + " [pid = " + this.pid + "]"));
                }
                this.process.destroy();
                this.onExit(this.process.waitFor());
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Killed process " + this.process + " [pid = " + this.pid + "]"));
                }
            }
            catch (Exception e) {
                this.log.error((Object)("ERROR: destroying process " + this.process + " [pid = " + this.pid + "]"));
                throw e;
            }
        }
    }

    public void open(int fd) throws IOException {
        if (fd != this.FD_STD_IN) {
            throw new IOException("Only IRemoteProcessLauncher.FD_STD_IN is supported");
        }
    }

    public void write(int fd, byte[] data) throws IOException {
        if (fd != this.FD_STD_IN) {
            return;
        }
        this.os.write(data);
        this.os.flush();
    }

    public void close(int fd) {
        if (fd != this.FD_STD_IN) {
            return;
        }
        try {
            this.os.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        return "Process: [" + this.pid + "] owner: " + this.getOwnerRegistryPath();
    }

    private class OutputHandler
    extends OutputStream {
        private final int fd;
        private static final int MAX_CHUNK_SIZE = 8192;
        private final ByteArrayOutputStream buffer = new ByteArrayOutputStream(8192);

        public OutputHandler(int fd) {
            this.fd = fd;
        }

        public void write(int b) throws IOException {
            this.buffer.write(b);
            if (this.buffer.size() >= 8192) {
                this.flush();
            }
        }

        public void flush() throws IOException {
            if (this.buffer.size() > 0) {
                if (LocalProcess.this.listener != null) {
                    LocalProcess.this.listener.onProcessOutput(this.fd, this.buffer.toByteArray());
                }
                this.buffer.reset();
            }
        }

        public void close() throws IOException {
            this.flush();
            super.close();
        }
    }
}

