/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.meshkeeper.launcher;

import java.io.File;
import java.util.Arrays;
import java.util.LinkedList;
import org.fusesource.meshkeeper.MeshKeeper;
import org.fusesource.meshkeeper.MeshKeeperFactory;
import org.fusesource.meshkeeper.launcher.LaunchAgent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main {
    private static final void showUsage() {
        System.out.println("Usage:");
        System.out.println("Args:");
        System.out.println("  -h,--help                   -- this message");
        System.out.println("  --registry <uri>            -- specifies the uri of a control server registry.");
        System.out.println("  [--directory <directory>]   -- specifies data directory used by the Launcher.");
        System.out.println("  [--agent-id <name>]         -- specifies the id of the agent, defaults to the machine's host name.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String jv = System.getProperty("java.version").substring(0, 3);
        if (jv.compareTo("1.5") < 0) {
            System.err.println("The Launch Agent requires jdk 1.5 or higher to run, the current java version is " + System.getProperty("java.version"));
            System.exit(-1);
            return;
        }
        if (System.getProperty("meshkeeper.application") == null) {
            System.setProperty("meshkeeper.application", Main.class.getName());
        }
        MeshKeeper meshKeeper = null;
        String regisitry = null;
        String agentId = null;
        String directory = MeshKeeperFactory.getDefaultAgentDirectory().getPath();
        LinkedList<String> alist = new LinkedList<String>(Arrays.asList(args));
        try {
            while (!alist.isEmpty()) {
                String arg = alist.removeFirst();
                if (arg.equals("--help") || arg.equals("-h")) {
                    Main.showUsage();
                    return;
                }
                if (arg.equals("--registry")) {
                    Main.assertHasAdditionalArg(alist, "Expected uri after --registry");
                    regisitry = alist.removeFirst();
                    continue;
                }
                if (arg.equals("--directory")) {
                    Main.assertHasAdditionalArg(alist, "Directory expected after --directory");
                    directory = alist.removeFirst();
                    continue;
                }
                if (!arg.equals("--agent-id")) continue;
                Main.assertHasAdditionalArg(alist, "Name expected after --agent-id");
                agentId = alist.removeFirst();
            }
            if (regisitry == null) {
                throw new UsageException("The --registry option is required.");
            }
            System.out.println("Starting Launch Agent against registry: " + regisitry);
            meshKeeper = MeshKeeperFactory.createMeshKeeper(regisitry, new File(directory));
            LaunchAgent agent = new LaunchAgent();
            if (agentId != null) {
                agent.setAgentId(agentId);
            }
            agent.setDirectory(new File(directory));
            agent.setMeshKeeper(meshKeeper);
            agent.start();
            agent.join();
        }
        catch (UsageException e) {
            System.out.println("Invalid usage: " + e.getMessage());
            System.out.println();
            Main.showUsage();
            System.exit(-1);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-2);
        }
        finally {
            try {
                if (meshKeeper != null) {
                    meshKeeper.destroy();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(-3);
            }
        }
        System.exit(0);
    }

    private static void assertHasAdditionalArg(LinkedList<String> alist, String message) throws Exception {
        if (alist.isEmpty()) {
            throw new UsageException(message);
        }
    }

    static class UsageException
    extends Exception {
        private static final long serialVersionUID = 1L;

        UsageException(String message) {
            super(message);
        }
    }
}

