/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.meshkeeper.launcher;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.fusesource.meshkeeper.MeshContainer;
import org.fusesource.meshkeeper.MeshKeeper;
import org.fusesource.meshkeeper.MeshKeeperFactory;
import org.fusesource.meshkeeper.distribution.PluginClassLoader;
import org.fusesource.meshkeeper.launcher.MeshContainerService;
import org.fusesource.meshkeeper.launcher.RemoteBootstrap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeshContainer
implements MeshContainerService,
MeshContainer.MeshContainerContext {
    private static MeshKeeper mesh;
    private static final Log LOG;
    private static boolean isInMeshContainer;
    private HashMap<String, Object> hosted = new HashMap();
    private String name;
    private CountDownLatch closeLatch = new CountDownLatch(1);

    private MeshContainer(String name) {
        this.name = name;
        isInMeshContainer = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized <T extends Serializable> T host(String name, T object, Class<?> ... interfaces) throws Exception {
        T proxy;
        block7: {
            proxy = null;
            try {
                if (!this.hosted.containsKey(name)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(this + " Hosting: " + name + ":" + object));
                    }
                    proxy = mesh.remoting().export(object, new Class[0]);
                    try {
                        this.hosted.put(name, object);
                        break block7;
                    }
                    finally {
                        this.initializeObject(object);
                    }
                }
                throw new Exception("Already hosting an object with name " + name);
            }
            catch (Exception e) {
                LOG.warn((Object)("Error hosting " + name), (Throwable)e);
                if (proxy == null) break block7;
                this.unhost(name);
                throw e;
            }
        }
        return proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void unhost(String name) throws Exception {
        Object d = this.hosted.get(name);
        if (d != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this + " Hosting: " + name + ":" + d));
            }
            try {
                mesh.remoting().unexport(d);
            }
            finally {
                this.destroyObject(d);
            }
        }
    }

    @Override
    public <R extends Runnable & Serializable> void run(final R r) throws Exception {
        Object wrapper = r;
        if (r instanceof MeshContainer.Hostable) {
            this.initializeObject(r);
            wrapper = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        r.run();
                    }
                    finally {
                        try {
                            MeshContainer.this.destroyObject(r);
                        }
                        catch (Exception e) {
                            LOG.warn((Object)"Runnable destroy error", (Throwable)e);
                        }
                    }
                }
            };
            ((MeshContainer.Hostable)r).initialize(this);
        }
        mesh.getExecutorService().execute((Runnable)wrapper);
    }

    @Override
    public <T, C extends Callable<T> & Serializable> T call(C c) throws Exception {
        this.initializeObject(c);
        Exception first = null;
        try {
            T t = c.call();
            return t;
        }
        catch (Exception e) {
            first = e;
            throw e;
        }
        finally {
            try {
                this.destroyObject(c);
            }
            catch (Exception e) {
                if (first != null) {
                    throw first;
                }
                throw e;
            }
        }
    }

    private void initializeObject(Object o) throws Exception {
        if (o instanceof MeshContainer.Hostable) {
            ((MeshContainer.Hostable)o).initialize(this);
        }
    }

    private void destroyObject(Object o) throws Exception {
        if (o instanceof MeshContainer.Hostable) {
            ((MeshContainer.Hostable)o).destroy(this);
        }
    }

    @Override
    public void close() {
        this.closeLatch.countDown();
    }

    public static MeshKeeper getMeshKeeper() {
        return mesh;
    }

    public static boolean isInMeshContainer() {
        return isInMeshContainer;
    }

    @Override
    public MeshKeeper getContainerMeshKeeper() {
        return mesh;
    }

    @Override
    public String getContainerName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static final void main(String[] args) {
        block16: {
            if (args.length == 0) {
                System.err.println("Expected registry path");
            }
            String path = args[0];
            MeshContainer container = new MeshContainer(path);
            Throwable error = null;
            if (Boolean.getBoolean("meshkeeper.bootstrap")) {
                mesh = RemoteBootstrap.getMeshKeeper();
                mesh.setUserClassLoader(new MeshContainerClassLoader());
            } else {
                mesh = MeshKeeperFactory.createMeshKeeper();
            }
            MeshKeeper.DistributionRef ref = MeshContainer.getMeshKeeper().distribute(path, false, container, MeshContainerService.class);
            LOG.debug((Object)("Started MeshContainer: " + ref.getRegistryPath() + " cl: " + container.getClass().getClassLoader()));
            container.closeLatch.await();
            LOG.debug((Object)("Closing MeshContainer: " + ref.getRegistryPath() + " cl: " + container.getClass().getClassLoader()));
            try {
                if (mesh != null) {
                    mesh.destroy();
                }
            }
            catch (Exception thrown) {
                error = error == null ? thrown : error;
                LOG.error((Object)"MeshContainer error: ", (Throwable)thrown);
            }
            System.exit(error == null ? 0 : 1);
            break block16;
            catch (Throwable thrown) {
                try {
                    error = error == null ? thrown : error;
                    LOG.error((Object)"MeshContainer error: ", thrown);
                }
                catch (Throwable throwable) {
                    try {
                        if (mesh != null) {
                            mesh.destroy();
                        }
                    }
                    catch (Exception thrown2) {
                        error = error == null ? thrown2 : error;
                        LOG.error((Object)"MeshContainer error: ", (Throwable)thrown2);
                    }
                    System.exit(error == null ? 0 : 1);
                    throw throwable;
                }
                try {
                    if (mesh != null) {
                        mesh.destroy();
                    }
                }
                catch (Exception thrown3) {
                    error = error == null ? thrown3 : error;
                    LOG.error((Object)"MeshContainer error: ", (Throwable)thrown3);
                }
                System.exit(error == null ? 0 : 1);
            }
        }
    }

    static {
        LOG = LogFactory.getLog(MeshContainer.class);
        isInMeshContainer = false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MeshContainerClassLoader
    extends ClassLoader {
        ArrayList<ClassLoader> delegates = new ArrayList(2);

        MeshContainerClassLoader() {
            super(MeshContainer.class.getClassLoader());
            this.delegates.add(RemoteBootstrap.getClassLoader());
            this.delegates.add(PluginClassLoader.getDefaultPluginLoader());
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            try {
                return super.findClass(name);
            }
            catch (ClassNotFoundException cnfe) {
                for (ClassLoader delegate : this.delegates) {
                    try {
                        return delegate.loadClass(name);
                    }
                    catch (ClassNotFoundException cnfe2) {
                    }
                }
                throw new ClassNotFoundException(name);
            }
        }

        @Override
        protected URL findResource(String name) {
            URL url = super.findResource(name);
            for (ClassLoader delegate : this.delegates) {
                if (url != null) break;
                url = delegate.getResource(name);
            }
            return url;
        }

        @Override
        protected Enumeration<URL> findResources(String name) throws IOException {
            Enumeration<URL> urls = null;
            try {
                urls = super.findResources(name);
            }
            catch (IOException ioe) {
                // empty catch block
            }
            for (ClassLoader delegate : this.delegates) {
                if (urls != null) break;
                try {
                    urls = delegate.getResources(name);
                }
                catch (IOException ioe) {}
            }
            return urls;
        }
    }
}

