/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.meshkeeper.launcher;

import java.io.IOException;
import java.lang.reflect.Array;
import java.net.DatagramSocket;
import java.net.ServerSocket;
import java.util.Collection;
import java.util.HashSet;
import javax.net.ServerSocketFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PortReserver {
    public static final short TCP = 0;
    public static final short UDP = 1;
    private static final short NUM_PROTOCOLS = 2;
    private static HashSet<Integer>[] reserved;
    private static int[] next;
    private static int[] min;
    private static int[] max;
    private static boolean initialized;

    PortReserver() {
    }

    public static void setPortRange(short protocol, int lower, int upper) {
        PortReserver.min[protocol] = lower;
        PortReserver.max[protocol] = upper;
        PortReserver.next[protocol] = lower;
    }

    public static synchronized Integer[] reservePorts(short protocol, int count) throws IOException {
        PortReserver.initialize();
        Integer[] ret = new Integer[count];
        int start = next[protocol];
        for (int i = 0; i < count; ++i) {
            while (!PortReserver.checkPortFree(protocol, next[protocol])) {
                PortReserver.incrementNext(protocol);
                if (next[protocol] != start) continue;
                throw new IOException("No free ports available");
            }
            ret[i] = next[protocol];
            PortReserver.incrementNext(protocol);
        }
        return ret;
    }

    public static synchronized void releasePorts(short protocol, Collection<Integer> ports) {
        for (Integer i : ports) {
            reserved[protocol].remove(i);
        }
    }

    private static void incrementNext(short protocol) {
        if (next[protocol] == max[protocol]) {
            PortReserver.next[protocol] = min[protocol];
        } else {
            short s = protocol;
            next[s] = next[s] + 1;
        }
    }

    private static boolean checkPortFree(short protocol, int port) {
        if (reserved[protocol].contains(new Integer(port))) {
            return false;
        }
        switch (protocol) {
            case 0: {
                ServerSocket ss = null;
                try {
                    ss = ServerSocketFactory.getDefault().createServerSocket(port);
                    ss.close();
                    return true;
                }
                catch (IOException e) {
                    return false;
                }
            }
            case 1: {
                DatagramSocket ds = null;
                try {
                    ds = new DatagramSocket(port);
                    ds.close();
                    return true;
                }
                catch (IOException iOException) {
                    return false;
                }
            }
        }
        throw new IllegalArgumentException("Invalid protocol: " + protocol);
    }

    private static <T> T[] makeArray(Class<T> clazz, int size) {
        return (Object[])Array.newInstance(clazz, size);
    }

    private static void initialize() {
        if (!initialized) {
            initialized = true;
            for (short i = 0; i < 2; i = (short)(i + 1)) {
                PortReserver.setPortRange(i, 10000, 32768);
            }
        }
    }

    static {
        next = new int[2];
        min = new int[2];
        max = new int[2];
        initialized = false;
        reserved = PortReserver.makeArray(HashSet.class, 2);
        for (int i = 0; i < reserved.length; ++i) {
            PortReserver.reserved[i] = new HashSet();
        }
    }
}

