/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.meshkeeper.launcher;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedList;
import org.fusesource.meshkeeper.MeshKeeper;
import org.fusesource.meshkeeper.MeshKeeperFactory;
import org.fusesource.meshkeeper.classloader.ClassLoaderFactory;
import org.fusesource.meshkeeper.classloader.Marshalled;

public class RemoteBootstrap {
    public static final String BOOTSTRAP_PROPERTY = "meshkeeper.bootstrap";
    private static MeshKeeper mesh;
    private static ClassLoader classLoader;
    private File cache;
    private String classLoaderFactory;
    private String mainClass;
    private String[] args;
    private String meshKeeperUri;
    private String runnable;

    public static MeshKeeper getMeshKeeper() {
        return mesh;
    }

    public static ClassLoader getClassLoader() {
        return classLoader;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) throws Throwable {
        if (System.getProperty("meshkeeper.application") == null) {
            System.setProperty("meshkeeper.application", RemoteBootstrap.class.getName());
        }
        RemoteBootstrap main = new RemoteBootstrap();
        LinkedList<String> alist = new LinkedList<String>(Arrays.asList(args));
        try {
            while (!alist.isEmpty()) {
                String arg = alist.removeFirst();
                if (arg.equals("--help")) {
                    RemoteBootstrap.showUsage();
                    return;
                }
                if (arg.equals("--cache")) {
                    try {
                        main.setCache(new File(alist.removeFirst()).getCanonicalFile());
                        continue;
                    }
                    catch (Exception e) {
                        throw new SyntaxException("Expected a directoy after the --cache option.");
                    }
                }
                if (arg.equals("--distributor")) {
                    try {
                        main.setDistributor(alist.removeFirst());
                        continue;
                    }
                    catch (Exception e) {
                        throw new SyntaxException("Expected a url after the --distributor option.");
                    }
                }
                if (arg.equals("--runnable")) {
                    try {
                        main.setRunnable(alist.removeFirst());
                        continue;
                    }
                    catch (Throwable e) {
                        throw new SyntaxException("Expected a url after the --runnable option.");
                    }
                }
                if (arg.equals("--classloader")) {
                    try {
                        main.setClassLoader(alist.removeFirst());
                        continue;
                    }
                    catch (Throwable e) {
                        throw new SyntaxException("Expected a url after the --classloader option.");
                    }
                }
                main.setMainClass(arg);
                String[] a = new String[alist.size()];
                alist.toArray(a);
                main.setArgs(a);
                break;
            }
            if (main.getRunnable() == null) {
                if (main.getMainClass() == null) {
                    throw new SyntaxException("Main class not specified.");
                }
                if (main.getClassLoaderFactory() == null) {
                    throw new SyntaxException("--classloader not specified.");
                }
            }
            if (main.getCache() == null) {
                throw new SyntaxException("--cache not specified.");
            }
            if (main.getDistributor() == null) {
                throw new SyntaxException("--distributor not specified.");
            }
        }
        catch (SyntaxException e) {
            System.out.println("Invalid Syntax: " + e.getMessage());
            System.out.println();
            RemoteBootstrap.showUsage();
            Thread.currentThread();
            Thread.sleep(1000L);
            System.exit(2);
        }
        main.execute();
    }

    private static void showUsage() {
        System.out.println();
    }

    private void execute() throws Throwable {
        System.setProperty("meshkeeper.registry.uri", this.meshKeeperUri);
        System.setProperty(BOOTSTRAP_PROPERTY, "true");
        System.setProperty("meshkeeper.bootstrap.cache", this.cache.getPath());
        if (this.runnable != null) {
            System.setProperty("meshkeeper.bootstrap.runnable", this.runnable);
        } else {
            System.setProperty("meshkeeper.bootstrap.classloader", this.classLoaderFactory);
            System.setProperty("meshkeeper.bootstrap.mainclass", this.mainClass);
        }
        mesh = MeshKeeperFactory.createMeshKeeper(this.meshKeeperUri);
        System.out.println("bootstrap started...");
        if (this.runnable != null) {
            Runnable r = null;
            try {
                Marshalled marshalled = (Marshalled)mesh.registry().getRegistryObject(this.runnable);
                if (marshalled == null) {
                    throw new Exception("The runnable not found at: " + this.runnable);
                }
                ClassLoaderFactory clf = marshalled.getClassLoaderFactory();
                System.out.println("Setting up classloader...");
                classLoader = clf.createClassLoader(this.getClass().getClassLoader(), this.cache);
                System.out.println("Executing runnable.");
                r = (Runnable)marshalled.get(classLoader);
            }
            catch (Throwable e) {
                e.printStackTrace();
                System.exit(100);
            }
            r.run();
            try {
                System.exit(Integer.parseInt(System.getProperty("meshkeeper.bootstrap.exit", "0")));
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                System.exit(101);
            }
        } else {
            Method mainMethod = null;
            try {
                ClassLoaderFactory clf = (ClassLoaderFactory)mesh.registry().getRegistryObject(this.classLoaderFactory);
                System.out.println("Setting up classloader...");
                classLoader = clf.createClassLoader(this.getClass().getClassLoader(), this.cache);
                System.out.println("Executing main.");
                Class<?> clazz = classLoader.loadClass(this.mainClass);
                mainMethod = clazz.getMethod("main", String[].class);
            }
            catch (Throwable e) {
                e.printStackTrace();
                System.exit(100);
            }
            try {
                mainMethod.invoke(null, new Object[]{this.args});
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
    }

    public void setDistributor(String uri) {
        this.meshKeeperUri = uri;
    }

    public String getDistributor() {
        return this.meshKeeperUri;
    }

    public void setClassLoader(String classLoader) {
        this.classLoaderFactory = classLoader;
    }

    public void setCache(File cache) {
        this.cache = cache;
    }

    public File getCache() {
        return this.cache;
    }

    public String getClassLoaderFactory() {
        return this.classLoaderFactory;
    }

    public String[] getArgs() {
        return this.args;
    }

    public void setArgs(String[] args) {
        this.args = args;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public String getRunnable() {
        return this.runnable;
    }

    public void setRunnable(String runnable) {
        this.runnable = runnable;
    }

    static class SyntaxException
    extends Exception {
        private static final long serialVersionUID = 4997524790367555614L;

        SyntaxException(String message) {
            super(message);
        }
    }
}

