/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.meshkeeper.util;

import java.io.BufferedReader;
import java.io.StringReader;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.fusesource.meshkeeper.MeshProcessListener;

public class DefaultProcessListener
implements MeshProcessListener {
    Log LOG = LogFactory.getLog(DefaultProcessListener.class);
    protected String name = "";
    protected LinkedList<MeshProcessListener> delegates;
    protected boolean prefixEachLine = true;

    public DefaultProcessListener(String name) {
        this.name = name;
    }

    public synchronized void addDelegate(MeshProcessListener listener) {
        if (this.delegates == null) {
            this.delegates = new LinkedList();
        }
        if (!this.delegates.contains(listener)) {
            this.delegates.add(listener);
        }
    }

    public synchronized boolean removeDelegate(MeshProcessListener listener) {
        if (this.delegates == null) {
            return false;
        }
        return this.delegates.remove(listener);
    }

    public void onProcessError(Throwable thrown) {
        this.LOG.error((Object)this.format("ERROR: " + thrown));
        if (this.delegates != null) {
            for (MeshProcessListener listener : this.delegates) {
                listener.onProcessError(thrown);
            }
        }
    }

    public void onProcessExit(int exitCode) {
        this.LOG.info((Object)this.format("exited with " + exitCode));
        if (this.delegates != null) {
            for (MeshProcessListener listener : this.delegates) {
                listener.onProcessExit(exitCode);
            }
        }
    }

    public void onProcessInfo(String message) {
        this.LOG.info((Object)this.format(message));
        if (this.delegates != null) {
            for (MeshProcessListener listener : this.delegates) {
                listener.onProcessInfo(message);
            }
        }
    }

    public void onProcessOutput(int fd, byte[] output) {
        if (this.prefixEachLine) {
            BufferedReader reader = new BufferedReader(new StringReader(new String(output)));
            try {
                String line = reader.readLine();
                while (line != null) {
                    if (fd == 2) {
                        this.LOG.error((Object)this.prefix(line));
                    } else {
                        this.LOG.info((Object)this.prefix(line));
                    }
                    line = reader.readLine();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (fd == 2) {
            this.LOG.error((Object)this.format(new String(output)));
        } else {
            this.LOG.info((Object)this.format(new String(output)));
        }
        if (this.delegates != null) {
            for (MeshProcessListener listener : this.delegates) {
                listener.onProcessOutput(fd, output);
            }
        }
    }

    private String format(String s) {
        if (s.endsWith("\r\n")) {
            s = s.substring(0, s.length() - 2);
        } else if (s.endsWith("\n")) {
            s = s.substring(0, s.length() - 1);
        }
        return this.prefix(s);
    }

    private String prefix(String s) {
        if (this.name == null) {
            return s;
        }
        return this.name + ": " + s;
    }

    public String toString() {
        return this.name;
    }
}

