/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.meshkeeper.util;

import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.fusesource.meshkeeper.Distributable;
import org.fusesource.meshkeeper.MeshKeeper;

public class Exporter {
    Log log = LogFactory.getLog(this.getClass());
    MeshKeeper mesh;
    private Distributable source;
    private String path;
    private Distributable stub;
    private boolean sequential = true;

    public void export() throws Exception {
        if (this.stub == null) {
            if (this.path == null) {
                this.stub = this.mesh.remoting().export(this.source, new Class[0]);
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Exported:" + this.source));
                }
            } else {
                MeshKeeper.DistributionRef ref = this.mesh.distribute(this.path, true, this.source, new Class[0]);
                this.path = ref.getRegistryPath();
                this.stub = (Distributable)ref.getProxy();
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Registered as: " + ref.getRegistryPath() + " implementing: " + Arrays.asList(((Distributable)ref.getProxy()).getClass().getInterfaces())));
                }
            }
        }
    }

    public void destroy() throws Exception {
        if (this.stub != null) {
            this.mesh.undistribute(this.source);
        }
    }

    public void setMeshKeeper(MeshKeeper mesh) {
        this.mesh = mesh;
    }

    public MeshKeeper getMeshKeeper() {
        return this.mesh;
    }

    public Distributable getSource() {
        return this.source;
    }

    public void setSource(Distributable source) {
        this.source = source;
    }

    public Distributable getStub() {
        return this.stub;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setSequential(boolean sequential) {
        this.sequential = sequential;
    }

    public boolean getSequential() {
        return this.sequential;
    }
}

