/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.meshkeeper.util;

import java.util.LinkedList;
import java.util.regex.Pattern;
import org.fusesource.meshkeeper.util.NoOpProcessListener;

public abstract class ProcessOutputMatcher
extends NoOpProcessListener {
    private final String name;
    private LinkedList<Pattern> triggers = new LinkedList();
    private LinkedList<Pattern> filters = new LinkedList();

    public ProcessOutputMatcher(String name) {
        this.name = name;
    }

    public final void onProcessOutput(int fd, byte[] output) {
        String line = new String(output);
        if (this.matches(line)) {
            this.onMatch(line);
        }
    }

    protected abstract void onMatch(String var1);

    public String getName() {
        return this.name;
    }

    public final void addTriggerPattern(String regex) {
        this.triggers.add(Pattern.compile(regex, 8));
    }

    public final void addFilterPattern(String regex) {
        this.filters.add(Pattern.compile(regex, 8));
    }

    private boolean matches(String line) {
        for (Pattern p : this.triggers) {
            if (!p.matcher(line).find()) continue;
            for (Pattern f : this.filters) {
                if (!f.matcher(line).find()) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

