/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.meshkeeper.util.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoadingAwareObjectInputStream
extends ObjectInputStream {
    private static final ClassLoader FALLBACK_CLASS_LOADER = ClassLoadingAwareObjectInputStream.class.getClassLoader();
    private static final HashMap<String, Class<?>> primClasses = new HashMap(8, 1.0f);

    public ClassLoadingAwareObjectInputStream(InputStream in) throws IOException {
        super(in);
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass classDesc) throws IOException, ClassNotFoundException {
        String s = classDesc.getName();
        return this.load(s);
    }

    @Override
    protected Class<?> resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        Class[] cinterfaces = new Class[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            cinterfaces[i] = this.load(interfaces[i]);
        }
        try {
            return Proxy.getProxyClass(cinterfaces[0].getClassLoader(), cinterfaces);
        }
        catch (IllegalArgumentException e) {
            throw new ClassNotFoundException(null, e);
        }
    }

    protected ClassLoader[] getClassLoaders() {
        return new ClassLoader[]{Thread.currentThread().getContextClassLoader()};
    }

    private Class<?> load(String s) throws ClassNotFoundException {
        ClassLoader[] cls;
        for (ClassLoader cl : cls = this.getClassLoaders()) {
            try {
                return Class.forName(s, false, cl);
            }
            catch (ClassNotFoundException e) {
            }
        }
        Class<?> clazz = primClasses.get(s);
        if (clazz != null) {
            return clazz;
        }
        return Class.forName(s, false, FALLBACK_CLASS_LOADER);
    }

    static {
        primClasses.put("boolean", Boolean.TYPE);
        primClasses.put("byte", Byte.TYPE);
        primClasses.put("char", Character.TYPE);
        primClasses.put("short", Short.TYPE);
        primClasses.put("int", Integer.TYPE);
        primClasses.put("long", Long.TYPE);
        primClasses.put("float", Float.TYPE);
        primClasses.put("double", Double.TYPE);
        primClasses.put("void", Void.TYPE);
    }
}

