/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.meshkeeper.util.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.fusesource.meshkeeper.util.internal.IOSupport;

public class FileSupport {
    static final long ROUNDUP_MILLIS = 1999L;

    public static void recursiveDelete(String srcDir) throws IOException {
        block7: {
            File srcFile = new File(srcDir);
            FileSupport.checkDirectoryDepth(srcFile.getAbsolutePath(), "Directory depth is too shallow to risk recursive delete for path: " + srcFile.getAbsolutePath() + " directory depth should be at least 2 levels deep.", 2);
            if (!srcFile.exists()) break block7;
            if (srcFile.isFile()) {
                int retries = 0;
                while (!srcFile.delete()) {
                    if (retries > 20) {
                        throw new IOException("ERROR: Unable to delete file: " + srcFile.getAbsolutePath());
                    }
                    ++retries;
                }
            } else {
                String[] fileList = srcFile.list();
                for (int j = 0; j < fileList.length; ++j) {
                    FileSupport.recursiveDelete(srcDir + File.separator + fileList[j]);
                }
                int retries = 0;
                while (!srcFile.delete()) {
                    if (retries > 20) {
                        throw new IOException("ERROR: Unable to delete directory. Not empty?");
                    }
                    ++retries;
                }
            }
        }
    }

    private static void checkDirectoryDepth(String path, String message, int minDepth) throws IOException {
        int depth = 0;
        int index = -1;
        if (path.startsWith(File.separator + File.separator)) {
            depth -= 2;
        } else if (path.startsWith(File.separator)) {
            --depth;
        }
        while ((index = path.indexOf(File.separator, index + 1)) != -1) {
            ++depth;
        }
        if (minDepth > depth) {
            throw new IOException(message);
        }
    }

    public static boolean recursiveDelete(File file) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                FileSupport.recursiveDelete(files[i]);
            }
        }
        return file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(InputStream source, File target) throws IOException {
        FileOutputStream os = new FileOutputStream(target);
        try {
            IOSupport.copy(source, os);
        }
        finally {
            IOSupport.close(os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] read(File file, long pos, int length) throws IOException {
        RandomAccessFile is = new RandomAccessFile(file, "r");
        try {
            byte[] rc;
            long remaining = is.length() - pos;
            if (remaining < 0L) {
                remaining = 0L;
            }
            if ((rc = new byte[(int)Math.min(remaining, (long)length)]).length == 0) {
                byte[] byArray = rc;
                return byArray;
            }
            is.seek(pos);
            is.readFully(rc);
            byte[] byArray = rc;
            return byArray;
        }
        finally {
            is.close();
        }
    }

    public static File jar(File source) throws IOException {
        File tempJar = File.createTempFile("temp", ".jar");
        FileSupport.jar(source, tempJar);
        return tempJar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void jar(File source, File target) throws IOException {
        ZipOutputStream os = new ZipOutputStream(new FileOutputStream(target));
        try {
            os.setMethod(8);
            os.setLevel(5);
            FileSupport.recusiveJar(os, source, null);
        }
        finally {
            IOSupport.close(os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void recusiveJar(ZipOutputStream os, File source, String jarpath) throws IOException {
        String prefix = "";
        if (jarpath != null) {
            ZipEntry entry = new ZipEntry(jarpath);
            entry.setTime(source.lastModified() + 1999L);
            os.putNextEntry(entry);
            prefix = jarpath + "/";
        }
        if (source.isDirectory()) {
            for (File file : source.listFiles()) {
                FileSupport.recusiveJar(os, file, prefix + file.getName());
            }
        } else {
            FileInputStream is = new FileInputStream(source);
            try {
                IOSupport.copy(is, os);
            }
            finally {
                IOSupport.close(is);
            }
        }
    }
}

