/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.meshkeeper.util.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicLong;

public class ProcessSupport {
    private static final AtomicLong ID_GENERATOR = new AtomicLong(0L);

    private static String getNextAnonymousId() {
        return "anonymous:" + ID_GENERATOR.incrementAndGet();
    }

    public static String caputure(Process process) throws InterruptedException {
        return ProcessSupport.caputure(ProcessSupport.getNextAnonymousId(), process);
    }

    public static String caputure(String id, Process process) throws InterruptedException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        if (ProcessSupport.system(id, process, out, null) != 0) {
            return null;
        }
        return out.toString();
    }

    public static int system(Process process) throws InterruptedException {
        return ProcessSupport.system(ProcessSupport.getNextAnonymousId(), process);
    }

    public static int system(String id, Process process) throws InterruptedException {
        return ProcessSupport.system(id, process, System.out, System.err);
    }

    public static int system(String id, Process process, OutputStream sout, OutputStream serr) throws InterruptedException {
        final CountDownLatch done = new CountDownLatch(1);
        ProcessSupport.watch(id, process, sout, serr, new Runnable(){

            public void run() {
                done.countDown();
            }
        });
        done.await();
        return process.exitValue();
    }

    public static void watch(String id, final Process process, OutputStream out, OutputStream err, final Runnable onExit) {
        final StreamPump errorHandler = new StreamPump("Error Pump for Process: " + id, process.getErrorStream(), err);
        errorHandler.start();
        final StreamPump outputHandler = new StreamPump("Output Pump for Process: " + id, process.getInputStream(), out);
        outputHandler.start();
        if (onExit != null) {
            new Thread("Exit Watcher for Process: " + id){

                public void run() {
                    try {
                        process.waitFor();
                        errorHandler.join();
                        outputHandler.join();
                        onExit.run();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }.start();
        }
    }

    private static class StreamPump
    extends Thread {
        private final InputStream in;
        private OutputStream out;

        public StreamPump(String name, InputStream in, OutputStream out) {
            super(name);
            this.in = in;
            this.out = out;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                int count;
                byte[] buffer = new byte[1204];
                while ((count = this.in.read(buffer, 0, buffer.length)) >= 0) {
                    if (this.out == null) continue;
                    this.out.write(buffer, 0, count);
                    if (count >= buffer.length || this.in.available() != 0) continue;
                    try {
                        Thread.sleep(50L);
                        if (this.in.available() > 0) {
                            continue;
                        }
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                    }
                    this.out.flush();
                }
            }
            catch (IOException expected) {
            }
            finally {
                try {
                    this.in.close();
                }
                catch (Throwable e) {}
                try {
                    this.out.close();
                }
                catch (Throwable e) {}
            }
        }
    }
}

