/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.rmiviajms;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.RemoteObject;
import java.rmi.server.ServerCloneException;
import java.rmi.server.UnicastRemoteObject;
import org.fusesource.rmiviajms.internal.JMSRemoteRef;
import org.fusesource.rmiviajms.internal.JMSRemoteSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMSRemoteObject
extends RemoteObject
implements Serializable {
    public static final String MULTICAST_PREFIX = "multicast:";
    private static final ThreadLocal<Long> NEXT_INVOCATION_TIMEOUT = new ThreadLocal();

    protected JMSRemoteObject() throws RemoteException {
        JMSRemoteObject.exportObject(this);
    }

    protected JMSRemoteObject(String destination) throws RemoteException {
        JMSRemoteObject.exportObject(this, destination);
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            JMSRemoteObject cloned = (JMSRemoteObject)super.clone();
            JMSRemoteObject.exportObject(cloned);
            return cloned;
        }
        catch (RemoteException e) {
            throw new ServerCloneException("Clone failed", e);
        }
    }

    public static void addOneWayAnnotation(Class<? extends Annotation> annotation) {
        JMSRemoteRef.addOneWayAnnotation(annotation);
    }

    public static Remote export(Object obj, Class<?> ... interfaces) throws Exception {
        return JMSRemoteObject.export(obj, null, interfaces);
    }

    public static Remote export(Object obj, String destination, Class<?> ... interfaces) throws Exception {
        if (JMSRemoteRef.isRemoteProxy(obj)) {
            return (Remote)obj;
        }
        JMSRemoteRef ref = new JMSRemoteRef();
        if (destination == null) {
            JMSRemoteSystem.INSTANCE.exportNonRemote(obj, interfaces, ref);
        } else {
            JMSRemoteSystem.INSTANCE.exportNonRemote(obj, interfaces, destination, ref);
        }
        return ref.getProxy();
    }

    public static Remote exportObject(Remote obj) throws RemoteException {
        return JMSRemoteObject.exportObject(obj, null);
    }

    public static Remote exportObject(Remote obj, String destination) throws RemoteException {
        if (JMSRemoteRef.isRemoteProxy(obj)) {
            return obj;
        }
        JMSRemoteRef ref = new JMSRemoteRef();
        if (obj instanceof JMSRemoteObject) {
            ((JMSRemoteObject)obj).ref = ref;
        }
        if (destination == null) {
            JMSRemoteSystem.INSTANCE.export(ref, obj);
        } else {
            JMSRemoteSystem.INSTANCE.export(ref, obj, destination);
        }
        return ref.getProxy();
    }

    public static boolean unexportObject(Remote obj, boolean force) throws NoSuchObjectException {
        try {
            return JMSRemoteSystem.INSTANCE.unexport(obj, force);
        }
        catch (NoSuchObjectException e) {
            try {
                return UnicastRemoteObject.unexportObject(obj, force);
            }
            catch (NoSuchObjectException noSuchObjectException) {
                throw e;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public static void resetSystem() throws InterruptedException {
        JMSRemoteSystem.INSTANCE.reset();
    }

    public static Remote toStub(Remote obj) throws NoSuchObjectException {
        if (JMSRemoteRef.isRemoteProxy(obj)) {
            return obj;
        }
        JMSRemoteRef ref = JMSRemoteSystem.INSTANCE.getExportedRemoteRef(obj);
        return ref.getProxy();
    }

    protected Object writeReplace() throws ObjectStreamException {
        return ((JMSRemoteRef)this.ref).getProxy();
    }

    public static <T> T toProxy(String destination, Class<T> mainInterface, Class<?> ... extraInterface) throws RemoteException {
        return JMSRemoteRef.toProxy(destination, mainInterface, extraInterface);
    }

    public static void setNextInvocationTimeout(Long timeout) {
        NEXT_INVOCATION_TIMEOUT.set(timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long removeNextInvocationTimeout() {
        try {
            Long l = NEXT_INVOCATION_TIMEOUT.get();
            return l;
        }
        finally {
            NEXT_INVOCATION_TIMEOUT.set(null);
        }
    }
}

