/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.rmiviajms.internal;

import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.fusesource.rmiviajms.internal.JMSRemoteSystem;

public final class ActiveMQRemoteSystem
extends JMSRemoteSystem {
    public static final String CONNECT_URL_PROPNAME = "org.fusesource.rmiviajms.CONNECT_URL";
    public static final String CONNECT_URL = System.getProperty("org.fusesource.rmiviajms.CONNECT_URL", "tcp://localhost:61616");
    public static final String QUEUE_PREFIX = System.getProperty("org.fusesource.rmiviajms.QUEUE_PREFIX", "rmiviajms.");

    protected ConnectionFactory createConnectionFactory() {
        return new ActiveMQConnectionFactory(CONNECT_URL);
    }

    protected Destination createQueue(String queueName) {
        return new ActiveMQQueue(QUEUE_PREFIX + queueName);
    }

    protected Destination createTopic(String topicName) {
        return new ActiveMQTopic(QUEUE_PREFIX + topicName);
    }
}

