/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.rmiviajms.internal;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.rmi.server.ExportException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.WeakHashMap;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.Factory;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.fusesource.rmiviajms.internal.JMSRemoteSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CGLibProxyAdapter {
    private static Map<Class<?>, Object> generatedClasses = Collections.synchronizedMap(new WeakHashMap());
    private static final HashSet<String> PASSED_OBJECT_METHODS = new HashSet();

    public static InvocationHandler getInvocationHandler(Object proxy) {
        return ((HandlerAdapter)((Factory)proxy).getCallback((int)0)).serializer.handler;
    }

    public static boolean isProxyClass(Class<?> cl) {
        return CGILibSerializableProxy.class.isAssignableFrom(cl);
    }

    public static Object newProxyInstance(Class<?> superclass, Class<?>[] interfaces, InvocationHandler h) throws ExportException {
        HandlerAdapter ha = new HandlerAdapter(h, superclass, interfaces);
        if (interfaces != null) {
            Class<?>[] source = interfaces;
            interfaces = new Class[source.length + 1];
            System.arraycopy(source, 0, interfaces, 1, source.length);
        } else {
            interfaces = new Class[]{CGILibSerializableProxy.class};
        }
        try {
            superclass.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException nsme) {
            throw new ExportException("Can't export " + superclass.getName() + " because it doesn't define a no arg constructor. Try exporting with specified service interfaces", nsme);
        }
        Enhancer e = new Enhancer();
        e.setClassLoader(JMSRemoteSystem.INSTANCE.getUserClassLoader(ha));
        e.setSuperclass(superclass);
        e.setInterfaces((Class[])interfaces);
        e.setCallback((Callback)ha);
        Object obj = e.create();
        generatedClasses.put(obj.getClass(), null);
        return obj;
    }

    static {
        PASSED_OBJECT_METHODS.add("hashCode");
        PASSED_OBJECT_METHODS.add("equals");
        PASSED_OBJECT_METHODS.add("toString");
    }

    public static interface CGILibSerializableProxy
    extends Serializable {
        public Object writeReplace() throws ObjectStreamException;
    }

    private static class CGLibProxySerializer
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private InvocationHandler handler;
        private String superclass;
        private String[] interfaces;

        private CGLibProxySerializer() {
        }

        public Object readResolve() throws ObjectStreamException {
            try {
                ClassLoader cl = JMSRemoteSystem.INSTANCE.getUserClassLoader(this);
                Class<?> superclass = cl.loadClass(this.superclass);
                Class[] interfaces = null;
                if (this.interfaces != null) {
                    interfaces = new Class[this.interfaces.length];
                    for (int i = 0; i < this.interfaces.length; ++i) {
                        interfaces[i] = cl.loadClass(this.interfaces[i]);
                    }
                }
                return CGLibProxyAdapter.newProxyInstance(superclass, interfaces, this.handler);
            }
            catch (ClassNotFoundException e) {
                ObjectStreamException oe = new ObjectStreamException(e.getMessage()){};
                oe.initCause(e);
                throw oe;
            }
            catch (ExportException ee) {
                ObjectStreamException oe = new ObjectStreamException(ee.getMessage()){};
                oe.initCause(ee);
                throw oe;
            }
        }

        static /* synthetic */ String[] access$302(CGLibProxySerializer x0, String[] x1) {
            x0.interfaces = x1;
            return x1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HandlerAdapter
    implements MethodInterceptor {
        CGLibProxySerializer serializer = new CGLibProxySerializer();

        public HandlerAdapter(InvocationHandler handler, Class<?> superclass, Class<?>[] interfaces) {
            this.serializer.handler = handler;
            this.serializer.superclass = superclass.getName();
            if (interfaces != null) {
                CGLibProxySerializer.access$302(this.serializer, new String[interfaces.length]);
                for (int i = 0; i < interfaces.length; ++i) {
                    ((CGLibProxySerializer)this.serializer).interfaces[i] = interfaces[i].getName();
                }
            }
        }

        public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
            if (method.getName().equals("writeReplace")) {
                return this.serializer;
            }
            if (method.getDeclaringClass() == Object.class && !PASSED_OBJECT_METHODS.contains(method.getName())) {
                return proxy.invokeSuper(obj, args);
            }
            return this.serializer.handler.invoke(obj, method, args);
        }
    }
}

