/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.rmiviajms.internal;

import java.rmi.NoSuchObjectException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import org.fusesource.rmiviajms.internal.JMSRemoteSystem;
import org.fusesource.rmiviajms.internal.Request;
import org.fusesource.rmiviajms.internal.Response;
import org.fusesource.rmiviajms.internal.Skeleton;

final class DispatchTask
implements Runnable {
    private final ObjectMessage msg;
    private final boolean oneway;
    private final JMSRemoteSystem remoteSystem;

    public DispatchTask(JMSRemoteSystem remoteSystem, ObjectMessage msg, boolean oneway) {
        this.remoteSystem = remoteSystem;
        this.msg = msg;
        this.oneway = oneway;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            long oid = this.msg.getLongProperty("object");
            long requestId = -1L;
            if (!this.oneway) {
                requestId = this.msg.getLongProperty("request");
            }
            Skeleton exportedObject = this.remoteSystem.exportedSkeletonsById.get(oid);
            Response response = null;
            Request request = null;
            if (exportedObject == null) {
                response = new Response(requestId, null, new NoSuchObjectException("" + oid));
            } else {
                ClassLoader old = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(this.remoteSystem.getUserClassLoader(this));
                    request = (Request)this.msg.getObject();
                    response = exportedObject.invoke(request);
                }
                catch (Throwable thrown) {
                    System.err.println("Error in rmi dispatch for " + exportedObject + "-" + exportedObject.getTargetClassLoader() + " / " + this.remoteSystem.getUserClassLoader());
                    thrown.printStackTrace();
                    response = new Response(requestId, null, thrown);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(old);
                }
            }
            if (!this.oneway) {
                this.remoteSystem.sendResponse((Message)this.msg, response);
            } else if (response.exception != null) {
                response.exception.printStackTrace();
            }
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
        catch (Throwable thrown) {
            thrown.printStackTrace();
        }
    }
}

